/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values.interactions;

import carpet.script.value.MapValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.interactions.InteractionValue;
import net.replaceitem.discarpet.script.values.interactions.ModalInteractionOptionValue;
import org.jetbrains.annotations.Nullable;

public class ModalInteractionValue
extends InteractionValue<ModalInteractionEvent> {
    public ModalInteractionValue(ModalInteractionEvent modalInteraction) {
        super(modalInteraction);
    }

    public static Value of(@Nullable ModalInteractionEvent modalInteractionEvent) {
        return ValueUtil.ofNullable(modalInteractionEvent, ModalInteractionValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "modal_interaction";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "custom_id" -> StringValue.of((String)((ModalInteractionEvent)this.delegate).getModalId());
            case "input_values_by_id" -> this.getInputValuesById();
            case "values_by_id" -> this.getValuesById();
            default -> super.getProperty(property);
        };
    }

    private MapValue getInputValuesById() {
        return MapValue.wrap(((ModalInteractionEvent)this.delegate).getValues().stream().filter(m -> m.getType() == Component.Type.TEXT_INPUT).collect(Collectors.toMap(m -> StringValue.of((String)m.getCustomId()), m -> StringValue.of((String)m.getAsString()))));
    }

    private MapValue getValuesById() {
        return MapValue.wrap(((ModalInteractionEvent)this.delegate).getValues().stream().collect(Collectors.toMap(m -> StringValue.of((String)m.getCustomId()), ModalInteractionOptionValue::of)));
    }
}

