/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values.interactions;

import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.dv8tion.jda.api.components.selections.EntitySelectMenu;
import net.dv8tion.jda.api.components.selections.SelectMenu;
import net.dv8tion.jda.api.components.selections.SelectOption;
import net.dv8tion.jda.api.components.selections.StringSelectMenu;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.events.interaction.component.GenericSelectMenuInteractionEvent;
import net.replaceitem.discarpet.script.util.ValueConversions;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.MessageValue;
import net.replaceitem.discarpet.script.values.interactions.InteractionValue;
import org.jetbrains.annotations.Nullable;

public class SelectMenuInteractionValue
extends InteractionValue<GenericSelectMenuInteractionEvent<?, ?>> {
    public SelectMenuInteractionValue(GenericSelectMenuInteractionEvent<?, ?> selectMenuInteraction) {
        super(selectMenuInteraction);
    }

    public static Value of(@Nullable GenericSelectMenuInteractionEvent<?, ?> genericSelectMenuInteractionEvent) {
        return ValueUtil.ofNullable(genericSelectMenuInteractionEvent, SelectMenuInteractionValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "select_menu_interaction";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "custom_id" -> StringValue.of((String)((GenericSelectMenuInteractionEvent)this.delegate).getComponentId());
            case "chosen" -> ListValue.wrap(((GenericSelectMenuInteractionEvent)this.delegate).getValues().stream().map(ValueConversions::toValue));
            case "options" -> this.getAllOptions();
            case "min" -> NumericValue.of((Number)((GenericSelectMenuInteractionEvent)this.delegate).getSelectMenu().getMinValues());
            case "max" -> NumericValue.of((Number)((GenericSelectMenuInteractionEvent)this.delegate).getSelectMenu().getMaxValues());
            case "placeholder" -> StringValue.of((String)((GenericSelectMenuInteractionEvent)this.delegate).getSelectMenu().getPlaceholder());
            case "message" -> MessageValue.of(((GenericSelectMenuInteractionEvent)this.delegate).getMessage());
            case "component_type" -> ValueUtil.ofEnum(((GenericSelectMenuInteractionEvent)this.delegate).getComponentType());
            default -> super.getProperty(property);
        };
    }

    private Value getAllOptions() {
        SelectMenu selectMenu = ((GenericSelectMenuInteractionEvent)this.delegate).getSelectMenu();
        Objects.requireNonNull(selectMenu);
        SelectMenu selectMenu2 = selectMenu;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringSelectMenu.class, EntitySelectMenu.class}, (Object)selectMenu2, n)) {
            case 0 -> {
                StringSelectMenu s = (StringSelectMenu)selectMenu2;
                yield ListValue.wrap(s.getOptions().stream().map(SelectOption::getValue).map(StringValue::of));
            }
            case 1 -> {
                EntitySelectMenu s = (EntitySelectMenu)selectMenu2;
                yield ListValue.wrap(s.getDefaultValues().stream().map(ISnowflake::getId).map(StringValue::of));
            }
            default -> ListValue.of((Value[])new Value[0]);
        };
    }
}

