/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values.interactions;

import carpet.script.value.BooleanValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.replaceitem.discarpet.script.util.ValueConversions;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.AttachmentValue;
import net.replaceitem.discarpet.script.values.ChannelValue;
import net.replaceitem.discarpet.script.values.RoleValue;
import net.replaceitem.discarpet.script.values.UserValue;
import net.replaceitem.discarpet.script.values.common.DiscordValue;
import org.jetbrains.annotations.Nullable;

public class SlashCommandInteractionOptionValue
extends DiscordValue<OptionMapping> {
    public SlashCommandInteractionOptionValue(OptionMapping option) {
        super(option);
    }

    public static Value of(@Nullable OptionMapping optionMapping) {
        return ValueUtil.ofNullable(optionMapping, SlashCommandInteractionOptionValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "slash_command_interaction_option";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "name" -> StringValue.of((String)((OptionMapping)this.delegate).getName());
            case "type" -> ValueUtil.ofEnum(((OptionMapping)this.delegate).getType());
            case "value" -> this.getValue();
            default -> super.getProperty(property);
        };
    }

    private Value getValue() {
        return switch (((OptionMapping)this.delegate).getType()) {
            default -> throw new MatchException(null, null);
            case OptionType.STRING -> StringValue.of((String)((OptionMapping)this.delegate).getAsString());
            case OptionType.INTEGER -> NumericValue.of((Number)((OptionMapping)this.delegate).getAsInt());
            case OptionType.BOOLEAN -> BooleanValue.of((boolean)((OptionMapping)this.delegate).getAsBoolean());
            case OptionType.USER -> UserValue.of(((OptionMapping)this.delegate).getAsUser());
            case OptionType.CHANNEL -> ChannelValue.of((Channel)((OptionMapping)this.delegate).getAsChannel());
            case OptionType.ROLE -> RoleValue.of(((OptionMapping)this.delegate).getAsRole());
            case OptionType.MENTIONABLE -> ValueConversions.toValue(((OptionMapping)this.delegate).getAsMentionable());
            case OptionType.NUMBER -> NumericValue.of((Number)((OptionMapping)this.delegate).getAsDouble());
            case OptionType.ATTACHMENT -> AttachmentValue.of(((OptionMapping)this.delegate).getAsAttachment());
            case OptionType.SUB_COMMAND, OptionType.SUB_COMMAND_GROUP, OptionType.UNKNOWN -> Value.NULL;
        };
    }
}

