/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.divein.extension;

import com.zigythebird.playeranim.animation.PlayerAnimationController;
import com.zigythebird.playeranimcore.animation.layered.IAnimation;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractModifier;
import com.zigythebird.playeranimcore.enums.TransformType;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.Optional;
import java.util.function.Function;

public final class AdjustmentModifier
extends AbstractModifier {
    public boolean enabled = true;
    private final Function<String, Optional<PartModifier>> source;

    public AdjustmentModifier(Function<String, Optional<PartModifier>> source) {
        this.source = source;
    }

    private float getFadeIn(float delta) {
        float fadeIn = 1.0f;
        IAnimation iAnimation = this.getAnim();
        if (iAnimation instanceof PlayerAnimationController) {
            PlayerAnimationController player = (PlayerAnimationController)iAnimation;
            float currentTick = player.getAnimationTicks() + delta;
            fadeIn = currentTick / player.getAnimationData().getPartialTick();
            fadeIn = Math.min(fadeIn, 1.0f);
        }
        return fadeIn;
    }

    private float getFadeOut(float delta) {
        float fadeOut = 1.0f;
        IAnimation iAnimation = this.getAnim();
        if (iAnimation instanceof PlayerAnimationController) {
            PlayerAnimationController player = (PlayerAnimationController)iAnimation;
            float currentTick = player.getAnimationTicks() + delta;
            float position = -1.0f * (currentTick - player.getAnimationData().getPartialTick());
            float length = player.getAnimationData().getPartialTick();
            if (length > 0.0f) {
                fadeOut = position / length;
                fadeOut = Math.min(fadeOut, 1.0f);
            }
        }
        return fadeOut;
    }

    private Vec3f transformVector(Vec3f vector, TransformType type, PartModifier partModifier, float fade) {
        switch (type) {
            case POSITION: {
                return vector.add(partModifier.offset);
            }
            case ROTATION: {
                return vector.add(partModifier.rotation.mul(fade));
            }
            case BEND: {
                return vector;
            }
        }
        return vector;
    }

    public record PartModifier(Vec3f rotation, Vec3f offset) {
    }
}

