/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.divein.network;

import com.google.common.collect.Iterables;
import com.moigferdsrte.divein.Divein;
import com.moigferdsrte.divein.event.api.Event;
import com.moigferdsrte.divein.event.api.ServersideDiveEvents;
import com.moigferdsrte.divein.network.Packets;
import java.util.Collection;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class ServerNetwork {
    public static void handleDivePublish(Packets.AnimationPublish packet, MinecraftServer server, class_3222 player) {
        class_3218 world = (class_3218)Iterables.tryFind((Iterable)server.method_3738(), element -> element == player.method_51469()).orNull();
        class_243 velocity = packet.velocity();
        Packets.DiveAnimation forwardPacket = new Packets.DiveAnimation(player.method_5628(), packet.visuals(), packet.velocity());
        ServerNetwork.tracking(player).forEach(serverPlayer -> {
            try {
                if (serverPlayer.method_5628() != player.method_5628() && ServerNetwork.networkS2C_CanSend(serverPlayer, Packets.DiveAnimation.TYPE)) {
                    ServerNetwork.networkS2C_Send(serverPlayer, forwardPacket);
                }
            }
            catch (Exception e) {
                Divein.LOGGER.error("Failed to send dive animation packet to {}", (Object)serverPlayer.method_5476().getString());
            }
        });
        assert (world != null);
        world.method_8503().method_40000(() -> {
            Event.Proxy proxy = (Event.Proxy)ServersideDiveEvents.PLAYER_START;
            proxy.handlers.forEach(handler -> {
                handler.onPlayerStartedDiving(player, velocity);
                proxy.register(handler);
            });
        });
    }

    public static Collection<class_3222> tracking(class_3222 player) {
        return PlayerLookup.tracking((class_1297)player);
    }

    public static Collection<class_3222> around(class_3218 world, class_243 origin, double distance) {
        return PlayerLookup.around((class_3218)world, (class_243)origin, (double)distance);
    }

    public static boolean networkS2C_CanSend(class_3222 player, class_8710.class_9154<?> packetId) {
        return ServerPlayNetworking.canSend((class_3222)player, packetId);
    }

    public static void networkS2C_Send(class_3222 player, class_8710 payload) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static void networkC2S_Send(class_8710 payload) {
        ClientPlayNetworking.send((class_8710)payload);
    }
}

