/*
 * Decompiled with CFR 0.152.
 */
package org.moigferdsrte.mixin;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.moigferdsrte.Config;
import org.moigferdsrte.event.TriggerEventHandler;
import org.moigferdsrte.extension.AnimationEffect;
import org.moigferdsrte.network.Packets;
import org.moigferdsrte.network.ServerNetwork;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Minecraft.class}, priority=500)
public abstract class ClientPacketSenderMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Unique
    private boolean divein_1_21_1_neo$waterDrop;
    @Unique
    private boolean divein_1_21_1_neo$lavaDrop;

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        if (this.player == null) {
            return;
        }
        this.divein_1_21_1_neo$waterDrop = TriggerEventHandler.checkWaterBelow((Player)this.player, Config.fluidLevelDetectHeight);
        this.divein_1_21_1_neo$lavaDrop = TriggerEventHandler.checkLavaBelow((Player)this.player, Config.fluidLevelDetectHeight * 2);
        if ((this.divein_1_21_1_neo$waterDrop || this.divein_1_21_1_neo$lavaDrop) && this.player.getDeltaMovement().y < 0.0) {
            this.divein_1_21_1_neo$tryPlayAnimationOnServerside();
        }
    }

    @Unique
    private void divein_1_21_1_neo$tryPlayAnimationOnServerside() {
        boolean isFalling;
        Minecraft client = (Minecraft)this;
        if (this.player == null || client.isPaused() || client.screen != null) {
            return;
        }
        double sensitivity = Config.triggerSensitivity;
        if (sensitivity < 0.0) {
            sensitivity = 0.0;
        }
        if (sensitivity > 1.0) {
            sensitivity = 1.0;
        }
        boolean bl = isFalling = this.player.getDeltaMovement().y < sensitivity - 1.0 && !this.player.onGround() && Objects.requireNonNull(client.level).getBlockState(this.player.blockPosition().below()).is(BlockTags.AIR) && !this.player.getAbilities().flying;
        if (isFalling) {
            AnimationEffect.Visuals visuals;
            if (this.divein_1_21_1_neo$waterDrop) {
                visuals = new AnimationEffect.Visuals("dive", AnimationEffect.Particles.DIVE);
                ServerNetwork.networkC2S_Send(new Packets.AnimationPublish(this.player.getId(), visuals, this.player.getDeltaMovement()));
                AnimationEffect.playVisuals(visuals, (Player)this.player, this.player.getDeltaMovement());
            }
            if (this.divein_1_21_1_neo$lavaDrop) {
                visuals = new AnimationEffect.Visuals("lava_dive", AnimationEffect.Particles.DIVE);
                ServerNetwork.networkC2S_Send(new Packets.AnimationPublish(this.player.getId(), visuals, this.player.getDeltaMovement()));
                AnimationEffect.playVisuals(visuals, (Player)this.player, this.player.getDeltaMovement());
            }
        }
    }
}

