/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.divein.mixin;

import com.moigferdsrte.divein.Divein;
import com.moigferdsrte.divein.extension.AnimationEffect;
import com.moigferdsrte.divein.network.Packets;
import com.moigferdsrte.divein.network.ServerNetwork;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_310.class}, priority=500)
public abstract class ClientPacketSenderMixin {
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Unique
    private boolean waterDrop;
    @Unique
    private boolean lavaDrop;

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        if (this.field_1724 == null) {
            return;
        }
        this.waterDrop = Divein.checkWaterBelow((class_1657)this.field_1724, Divein.config.fluidLevelDetectHeight);
        this.lavaDrop = Divein.checkLavaBelow((class_1657)this.field_1724, Divein.config.fluidLevelDetectHeight * 2);
        if ((this.waterDrop || this.lavaDrop) && this.field_1724.method_18798().field_1351 < 0.0) {
            this.tryPlayAnimationOnServerside();
        }
    }

    @Unique
    private void tryPlayAnimationOnServerside() {
        boolean isFalling;
        class_310 client = (class_310)this;
        if (this.field_1724 == null || client.method_1493() || client.field_1755 != null) {
            return;
        }
        boolean hasRes = this.field_1724.method_6059(class_1294.field_5918);
        float sensitivity = Divein.config.triggerSensitivity;
        if (sensitivity < 0.0f) {
            sensitivity = 0.0f;
        }
        if (sensitivity > 1.0f) {
            sensitivity = 1.0f;
        }
        boolean bl = isFalling = this.field_1724.method_18798().field_1351 < (double)(sensitivity - 1.0f) && !this.field_1724.method_24828() && Objects.requireNonNull(client.field_1687).method_8320(this.field_1724.method_24515().method_10074()).method_26164(class_3481.field_51989) && !this.field_1724.method_31549().field_7479;
        if (isFalling) {
            AnimationEffect.Visuals visuals;
            if (this.waterDrop || hasRes) {
                visuals = new AnimationEffect.Visuals("dive", AnimationEffect.Particles.DIVE);
                ServerNetwork.networkC2S_Send(new Packets.AnimationPublish(this.field_1724.method_5628(), visuals, this.field_1724.method_18798()));
                AnimationEffect.playVisuals(visuals, (class_1657)this.field_1724, this.field_1724.method_18798());
            }
            if (this.lavaDrop) {
                visuals = new AnimationEffect.Visuals("lava_dive", AnimationEffect.Particles.DIVE);
                ServerNetwork.networkC2S_Send(new Packets.AnimationPublish(this.field_1724.method_5628(), visuals, this.field_1724.method_18798()));
                AnimationEffect.playVisuals(visuals, (class_1657)this.field_1724, this.field_1724.method_18798());
            }
        }
    }
}

