/*
 * Decompiled with CFR 0.152.
 */
package org.moigferdsrte.mixin;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.moigferdsrte.Config;
import org.moigferdsrte.Divein;
import org.moigferdsrte.event.TriggerEventHandler;
import org.moigferdsrte.extension.AdjustmentModifier;
import org.moigferdsrte.extension.AnimatablePlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin
extends Player
implements AnimatablePlayer {
    @Unique
    private static final Map<UUID, Boolean> divein_1_21_1_neo$playerAnimationStates = new HashMap<UUID, Boolean>();
    @Unique
    private final ExecutorService divein_1_21_1_neo$executorService = Executors.newSingleThreadExecutor();
    @Unique
    private final ModifierLayer<KeyframeAnimationPlayer> divein_1_21_1_neo$base = new ModifierLayer(null, new AbstractModifier[0]);
    @Unique
    private final SpeedModifier divein_1_21_1_neo$speedModifier = new SpeedModifier();
    @Unique
    private Vec3 divein_1_21_1_neo$lastRollDirection;

    public AbstractClientPlayerMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Override
    @TriggerEventHandler.SyncForServer
    public void divein_1_21_1$playDiveAnimation(String animationName, Vec3 direction) {
        if (divein_1_21_1_neo$playerAnimationStates.getOrDefault(this.uuid, false).booleanValue()) {
            return;
        }
        divein_1_21_1_neo$playerAnimationStates.put(this.uuid, true);
        try {
            KeyframeAnimation animation = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divein", (String)animationName));
            assert (animation != null);
            KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
            this.divein_1_21_1_neo$lastRollDirection = direction;
            this.divein_1_21_1_neo$speedModifier.speed = (float)Config.speedModifier;
            this.divein_1_21_1_neo$base.replaceAnimationWithFade(AbstractFadeModifier.functionalFadeIn((int)100, (modelName, type, value) -> value), (IAnimation)new KeyframeAnimationPlayer(copy.build()).setFirstPersonMode(FirstPersonMode.DISABLED).setFirstPersonConfiguration(new FirstPersonConfiguration().setShowRightArm(true).setShowLeftArm(true).setShowLeftItem(false)));
            this.divein_1_21_1_neo$executorService.execute(() -> {
                try {
                    Thread.sleep(1500L);
                    divein_1_21_1_neo$playerAnimationStates.put(this.uuid, false);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
        catch (Exception e) {
            Divein.LOGGER.error("Failed to play dive animation for player ", (Throwable)e);
            divein_1_21_1_neo$playerAnimationStates.put(this.uuid, false);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(ClientLevel clientLevel, GameProfile gameProfile, CallbackInfo ci) {
        AnimationStack stack = ((IAnimatedPlayer)this).getAnimationStack();
        this.divein_1_21_1_neo$base.addModifier((AbstractModifier)this.divein_1_21_1_neo$speedModifier, 0);
        this.divein_1_21_1_neo$speedModifier.speed = 1.02f;
        stack.addAnimLayer(1000, this.divein_1_21_1_neo$base);
    }

    @Unique
    private double divein_1_21_1_neo$angleWithSignBetween(Vec3 a, Vec3 b, Vec3 planeNormal) {
        double cosineTheta = a.dot(b) / (a.length() * b.length());
        double angle = Math.toDegrees(Math.acos(cosineTheta));
        Vec3 cross = a.cross(b);
        if (Double.isNaN(angle *= Math.signum(cross.dot(planeNormal)))) {
            return 0.0;
        }
        return angle;
    }

    @Unique
    private AdjustmentModifier divein_1_21_1_neo$createAdjustmentModifier() {
        AbstractClientPlayerMixin player = this;
        return new AdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if (partName.equals("body")) {
                if (this.divein_1_21_1_neo$lastRollDirection == null) {
                    return Optional.empty();
                }
            } else {
                return Optional.empty();
            }
            Vec3 absoluteOrientation = new Vec3(0.0, 0.0, 1.0).yRot((float)Math.toRadians(-1.0 * (double)player.yBodyRot));
            float angle = (float)this.divein_1_21_1_neo$angleWithSignBetween(absoluteOrientation, this.divein_1_21_1_neo$lastRollDirection, new Vec3(0.0, 1.0, 0.0));
            rotationY = (float)Math.toRadians(angle);
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }
}

