/*
 * Decompiled with CFR 0.152.
 */
package org.moigferdsrte.event;

import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluids;
import org.moigferdsrte.Config;

public class TriggerEventHandler {
    private static boolean hasTriggeredDive = false;
    static double sensitivity = Config.triggerSensitivity;

    public static boolean checkWaterBelow(Player player, int blocks) {
        if (player.isInWater()) {
            return true;
        }
        for (int i = 1; i <= blocks; ++i) {
            if (player.level().getBlockState(player.blockPosition().below(i)).is(Blocks.WATER) && player.level().getBlockState(player.blockPosition().below(i - 1)).is(BlockTags.AIR)) {
                if (!player.level().getBlockState(player.blockPosition().below(i + 1)).is(Blocks.WATER)) {
                    return false;
                }
                for (int j = 1; j <= Config.triggerDepth; ++j) {
                    if (player.level().getBlockState(player.blockPosition().below(i - 1 + j)).getFluidState().getType() == Fluids.WATER) continue;
                    return false;
                }
                return true;
            }
            if (!player.level().getBlockState(player.blockPosition().below(i)).is(BlockTags.AIR)) break;
        }
        return false;
    }

    public static boolean checkLavaBelow(Player player, int blocks) {
        if (player.isInLava()) {
            return true;
        }
        for (int i = 1; i <= blocks; ++i) {
            if (player.level().getBlockState(player.blockPosition().below(i)).getFluidState().getType() == Fluids.LAVA && player.level().getBlockState(player.blockPosition().below(i - 1)).is(BlockTags.AIR)) {
                for (int j = 1; j <= Config.triggerDepth; ++j) {
                    if (player.level().getBlockState(player.blockPosition().below(i - 1 + j)).getFluidState().getType() == Fluids.LAVA) continue;
                    return false;
                }
                return true;
            }
            if (!player.level().getBlockState(player.blockPosition().below(i)).is(BlockTags.AIR)) break;
        }
        return false;
    }

    public static boolean isHasTriggeredDive() {
        return hasTriggeredDive;
    }

    public static void setHasTriggeredDive(boolean hasTriggeredDive) {
        TriggerEventHandler.hasTriggeredDive = hasTriggeredDive;
    }

    public static @interface SyncForServer {
        public boolean value() default true;
    }
}

