/*
 * Decompiled with CFR 0.152.
 */
package org.moigferdsrte.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.moigferdsrte.extension.AnimationEffect;

public class Packets {

    public record DiveAnimation(int playerId, AnimationEffect.Visuals visuals, Vec3 velocity) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<DiveAnimation> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"divein", (String)"animation"));
        public static final StreamCodec<FriendlyByteBuf, DiveAnimation> CODEC = StreamCodec.ofMember(DiveAnimation::write, DiveAnimation::read);

        public static DiveAnimation read(FriendlyByteBuf buffer) {
            int playerId = buffer.readInt();
            AnimationEffect.Visuals visuals = new AnimationEffect.Visuals(buffer.readUtf(), AnimationEffect.Particles.valueOf(buffer.readUtf()));
            Vec3 velocity = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            return new DiveAnimation(playerId, visuals, velocity);
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.playerId);
            buffer.writeUtf(this.visuals.animationName());
            buffer.writeUtf(this.visuals.particles().toString());
            buffer.writeDouble(this.velocity.x);
            buffer.writeDouble(this.velocity.y);
            buffer.writeDouble(this.velocity.z);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record AnimationPublish(int playerId, AnimationEffect.Visuals visuals, Vec3 velocity) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<AnimationPublish> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"divein", (String)"publish"));
        public static final StreamCodec<FriendlyByteBuf, AnimationPublish> CODEC = StreamCodec.ofMember(AnimationPublish::write, AnimationPublish::read);

        public static AnimationPublish read(FriendlyByteBuf buffer) {
            int playerId = buffer.readInt();
            AnimationEffect.Visuals visuals = new AnimationEffect.Visuals(buffer.readUtf(), AnimationEffect.Particles.valueOf(buffer.readUtf()));
            Vec3 velocity = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            return new AnimationPublish(playerId, visuals, velocity);
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.playerId);
            buffer.writeUtf(this.visuals.animationName());
            buffer.writeUtf(this.visuals.particles().toString());
            buffer.writeDouble(this.velocity.x);
            buffer.writeDouble(this.velocity.y);
            buffer.writeDouble(this.velocity.z);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

