/*
 * Decompiled with CFR 0.152.
 */
package org.moigferdsrte.network;

import com.google.common.collect.Iterables;
import java.util.Collection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.moigferdsrte.Divein;
import org.moigferdsrte.event.api.Event;
import org.moigferdsrte.event.api.ServersideDiveEvents;
import org.moigferdsrte.network.Packets;

public class ServerNetwork {
    public static void handleDivePublish(Packets.AnimationPublish packet, MinecraftServer server, ServerPlayer player) {
        ServerLevel world = (ServerLevel)Iterables.tryFind((Iterable)server.getAllLevels(), element -> element == player.level()).orNull();
        Vec3 velocity = packet.velocity();
        Packets.DiveAnimation forwardPacket = new Packets.DiveAnimation(player.getId(), packet.visuals(), packet.velocity());
        ServerNetwork.tracking(player).forEach(serverPlayer -> {
            try {
                if (serverPlayer.getId() != player.getId() && ServerNetwork.networkS2C_CanSend(serverPlayer, Packets.DiveAnimation.TYPE)) {
                    ServerNetwork.networkS2C_Send(serverPlayer, forwardPacket);
                }
            }
            catch (Exception e) {
                Divein.LOGGER.error("Failed to send dive animation packet to {}", (Object)serverPlayer.getDisplayName().getString());
            }
        });
        assert (world != null);
        world.getServer().executeIfPossible(() -> {
            Event.Proxy proxy = (Event.Proxy)ServersideDiveEvents.PLAYER_START;
            proxy.handlers.forEach(handler -> handler.onPlayerStartedDiving(player, velocity));
        });
    }

    public static Collection<ServerPlayer> tracking(ServerPlayer player) {
        return player.serverLevel().getPlayers(serverPlayer -> serverPlayer.getId() != player.getId());
    }

    public static Collection<ServerPlayer> around(ServerLevel world, Vec3 origin, double distance) {
        return world.getPlayers(player -> player.position().distanceToSqr(origin) <= distance * distance);
    }

    public static boolean networkS2C_CanSend(ServerPlayer player, CustomPacketPayload.Type<?> packetId) {
        return true;
    }

    public static void networkS2C_Send(ServerPlayer player, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void networkC2S_Send(CustomPacketPayload payload) {
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

