/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.divein.mixin;

import com.moigferdsrte.divein.Divein;
import com.moigferdsrte.divein.event.DiveinEvent;
import com.moigferdsrte.divein.extension.AdjustmentModifier;
import com.moigferdsrte.divein.extension.AnimatablePlayer;
import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerMixin
extends class_1657
implements AnimatablePlayer {
    @Unique
    private static final Map<UUID, Boolean> playerAnimationStates = new HashMap<UUID, Boolean>();
    @Unique
    private final ExecutorService asyncPool = Executors.newSingleThreadExecutor();
    @Unique
    private final ModifierLayer<KeyframeAnimationPlayer> base = new ModifierLayer(null, new AbstractModifier[0]);
    @Unique
    private final SpeedModifier speedModifier = new SpeedModifier();
    @Unique
    private class_243 divingDirection;

    public AbstractClientPlayerMixin(class_1937 level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Override
    @DiveinEvent.SyncForServer
    public void divein_1_21_1$playDiveAnimation(String animationName, class_243 direction) {
        if (playerAnimationStates.getOrDefault(this.field_6021, false).booleanValue()) {
            return;
        }
        playerAnimationStates.put(this.field_6021, true);
        try {
            KeyframeAnimation animation = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)class_2960.method_60655((String)"divein", (String)animationName));
            if (animation == null) {
                return;
            }
            KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
            this.divingDirection = direction;
            this.speedModifier.speed = Divein.config.speedModifier;
            this.base.replaceAnimationWithFade(AbstractFadeModifier.functionalFadeIn((int)100, (modelName, type, value) -> value), (IAnimation)new KeyframeAnimationPlayer(copy.build()).setFirstPersonMode(FirstPersonMode.DISABLED).setFirstPersonConfiguration(new FirstPersonConfiguration().setShowRightArm(true).setShowLeftArm(true).setShowLeftItem(false)));
            System.out.println("Play animation:" + animationName);
            this.asyncPool.execute(() -> {
                try {
                    Thread.sleep(1500L);
                    playerAnimationStates.put(this.field_6021, false);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
        catch (Exception e) {
            Divein.LOGGER.error("Failed to play dive animation for player ", (Throwable)e);
            playerAnimationStates.put(this.field_6021, false);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(class_638 clientLevel, GameProfile gameProfile, CallbackInfo ci) {
        AnimationStack stack = ((IAnimatedPlayer)this).playerAnimator$getAnimationStack();
        this.base.addModifier((AbstractModifier)this.createAdjustmentModifier(), 0);
        this.base.addModifier((AbstractModifier)this.speedModifier, 0);
        this.speedModifier.speed = 1.02f;
        stack.addAnimLayer(1000, this.base);
    }

    @Unique
    private double angleWithSignBetween(class_243 a, class_243 b, class_243 planeNormal) {
        double cosineTheta = a.method_1026(b) / (a.method_1033() * b.method_1033());
        double angle = Math.toDegrees(Math.acos(cosineTheta));
        class_243 cross = a.method_1036(b);
        if (Double.isNaN(angle *= Math.signum(cross.method_1026(planeNormal)))) {
            return 0.0;
        }
        return angle;
    }

    @Unique
    private AdjustmentModifier createAdjustmentModifier() {
        AbstractClientPlayerMixin player = this;
        return new AdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if (partName.equals("body")) {
                if (this.divingDirection == null) {
                    return Optional.empty();
                }
            } else {
                return Optional.empty();
            }
            class_243 absoluteOrientation = new class_243(0.0, 0.0, 1.0).method_1024((float)Math.toRadians(-1.0 * (double)player.field_6283));
            float angle = (float)this.angleWithSignBetween(absoluteOrientation, this.divingDirection, new class_243(0.0, 1.0, 0.0));
            rotationY = (float)Math.toRadians(angle);
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }
}

