/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.divein.mixin;

import com.moigferdsrte.divein.Divein;
import com.moigferdsrte.divein.event.DiveinEvent;
import com.moigferdsrte.divein.extension.AdjustmentModifier;
import com.moigferdsrte.divein.extension.AnimatablePlayer;
import com.mojang.authlib.GameProfile;
import com.zigythebird.playeranim.accessors.IAnimatedPlayer;
import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranim.animation.PlayerAnimationController;
import com.zigythebird.playeranim.api.PlayerAnimationAccess;
import com.zigythebird.playeranimcore.animation.layered.ModifierLayer;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.SpeedModifier;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonConfiguration;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonMode;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_11901;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerMixin
extends class_1657
implements AnimatablePlayer,
class_11901 {
    @Unique
    private static final Map<UUID, Boolean> playerAnimationStates = new HashMap<UUID, Boolean>();
    @Unique
    private final ExecutorService asyncPool = Executors.newSingleThreadExecutor();
    @Deprecated
    @Unique
    private final ModifierLayer<PlayerAnimationController> base = new ModifierLayer(null, new AbstractModifier[0]);
    @Unique
    private final SpeedModifier speedModifier = new SpeedModifier(1.0f);
    @Unique
    private class_243 divingDirection;

    public AbstractClientPlayerMixin(class_1937 level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Override
    @DiveinEvent.SyncForServer
    public void divein_1_21_1$playDiveAnimation(String animationName, class_243 direction) {
        if (playerAnimationStates.getOrDefault(this.field_6021, false).booleanValue()) {
            return;
        }
        playerAnimationStates.put(this.field_6021, true);
        class_2960 loc = class_2960.method_60655((String)"divein", (String)animationName);
        try {
            assert (class_310.method_1551().field_1724 != null);
            PlayerAnimationController controller = (PlayerAnimationController)PlayerAnimationAccess.getPlayerAnimationLayer((class_742)class_310.method_1551().field_1724, (class_2960)loc);
            controller.setFirstPersonConfiguration(new FirstPersonConfiguration().setShowRightArm(true).setShowLeftArm(true).setShowLeftItem(false));
            controller.addModifier((AbstractModifier)new SpeedModifier(0.8923f), 0);
            controller.setFirstPersonMode(FirstPersonMode.DISABLED);
            controller.triggerAnimation(loc);
            this.asyncPool.execute(() -> {
                try {
                    Thread.sleep(1000L);
                    playerAnimationStates.put(this.field_6021, false);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
        catch (Exception e) {
            Divein.LOGGER.error("Failed to play dive animation for player ", (Throwable)e);
            playerAnimationStates.put(this.field_6021, false);
        }
    }

    @Unique
    protected float calculateProgress(float f, int length) {
        return (f + (float)this.field_6012) / (float)length;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(class_638 clientLevel, GameProfile gameProfile, CallbackInfo ci) {
        PlayerAnimManager stack = ((IAnimatedPlayer)this).playerAnimLib$getAnimManager();
        this.base.addModifier((AbstractModifier)this.speedModifier, 0);
        this.speedModifier.speed = 1.02f;
        stack.addAnimLayer(1000, this.base);
    }

    @Unique
    private double angleWithSignBetween(class_243 a, class_243 b, class_243 planeNormal) {
        double cosineTheta = a.method_1026(b) / (a.method_1033() * b.method_1033());
        double angle = Math.toDegrees(Math.acos(cosineTheta));
        class_243 cross = a.method_1036(b);
        if (Double.isNaN(angle *= Math.signum(cross.method_1026(planeNormal)))) {
            return 0.0;
        }
        return angle;
    }

    @Unique
    @Deprecated
    private AdjustmentModifier createAdjustmentModifier() {
        AbstractClientPlayerMixin player = this;
        return new AdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if (partName.equals("body")) {
                if (this.divingDirection == null) {
                    return Optional.empty();
                }
            } else {
                return Optional.empty();
            }
            class_243 absoluteOrientation = new class_243(0.0, 0.0, 1.0).method_1024((float)Math.toRadians(-1.0 * (double)player.field_6283));
            float angle = (float)this.angleWithSignBetween(absoluteOrientation, this.divingDirection, new class_243(0.0, 1.0, 0.0));
            rotationY = (float)Math.toRadians(angle);
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }
}

