/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.divein.mixin;

import com.moigferdsrte.divein.Config;
import com.moigferdsrte.divein.Divein;
import com.moigferdsrte.divein.events.DiveinEvent;
import com.moigferdsrte.divein.extension.AdjustmentModifier;
import com.moigferdsrte.divein.extension.AnimatablePlayer;
import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin
extends Player
implements AnimatablePlayer {
    @Unique
    private static final Map<UUID, Boolean> divein_1_20_1_forge$playerAnimationStates = new HashMap<UUID, Boolean>();
    @Unique
    private final ModifierLayer<KeyframeAnimationPlayer> divein_1_20_1_forge$base = new ModifierLayer(null, new AbstractModifier[0]);
    @Unique
    private final SpeedModifier divein_1_20_1_forge$speedModifier = new SpeedModifier();
    @Unique
    private Vec3 divein_1_20_1_forge$divingDirection;

    public AbstractClientPlayerMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Override
    @DiveinEvent.SyncForServer
    public void divein_1_21_1$playDiveAnimation(String animationName, Vec3 direction) {
        if (divein_1_20_1_forge$playerAnimationStates.getOrDefault(this.f_19820_, false).booleanValue()) {
            return;
        }
        divein_1_20_1_forge$playerAnimationStates.put(this.f_19820_, true);
        try {
            KeyframeAnimation animation = PlayerAnimationRegistry.getAnimation((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divein", (String)animationName));
            if (animation == null) {
                return;
            }
            KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
            this.divein_1_20_1_forge$divingDirection = direction;
            this.divein_1_20_1_forge$speedModifier.speed = (float)Config.speedModifier;
            this.divein_1_20_1_forge$base.replaceAnimationWithFade(AbstractFadeModifier.functionalFadeIn((int)100, (modelName, type, value) -> value), (IAnimation)new KeyframeAnimationPlayer(copy.build()).setFirstPersonMode(FirstPersonMode.DISABLED).setFirstPersonConfiguration(new FirstPersonConfiguration().setShowRightArm(true).setShowLeftItem(false)));
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    divein_1_20_1_forge$playerAnimationStates.put(this.f_19820_, false);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
        }
        catch (Exception e) {
            Divein.LOGGER.error("Failed to play dive animation for player ", (Throwable)e);
            divein_1_20_1_forge$playerAnimationStates.put(this.f_19820_, false);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(ClientLevel clientLevel, GameProfile gameProfile, CallbackInfo ci) {
        AnimationStack stack = ((IAnimatedPlayer)this).getAnimationStack();
        this.divein_1_20_1_forge$base.addModifier((AbstractModifier)this.divein_1_20_1_forge$speedModifier, 0);
        this.divein_1_20_1_forge$speedModifier.speed = 1.02f;
        stack.addAnimLayer(1000, this.divein_1_20_1_forge$base);
    }

    @Unique
    private double divein_1_20_1_forge$angleWithSignBetween(Vec3 a, Vec3 b, Vec3 planeNormal) {
        double cosineTheta = a.m_82526_(b) / (a.m_82553_() * b.m_82553_());
        double angle = Math.toDegrees(Math.acos(cosineTheta));
        Vec3 cross = a.m_82537_(b);
        if (Double.isNaN(angle *= Math.signum(cross.m_82526_(planeNormal)))) {
            return 0.0;
        }
        return angle;
    }

    @Unique
    private AdjustmentModifier createAdjustmentModifier() {
        AbstractClientPlayerMixin player = this;
        return new AdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if (partName.equals("body")) {
                if (this.divein_1_20_1_forge$divingDirection == null) {
                    return Optional.empty();
                }
            } else {
                return Optional.empty();
            }
            Vec3 absoluteOrientation = new Vec3(0.0, 0.0, 1.0).m_82524_((float)Math.toRadians(-1.0 * (double)player.f_20883_));
            float angle = (float)this.divein_1_20_1_forge$angleWithSignBetween(absoluteOrientation, this.divein_1_20_1_forge$divingDirection, new Vec3(0.0, 1.0, 0.0));
            rotationY = (float)Math.toRadians(angle);
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }
}

