/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.divein.mixin;

import com.moigferdsrte.divein.Config;
import com.moigferdsrte.divein.Divein;
import com.moigferdsrte.divein.extension.AnimationEffect;
import com.moigferdsrte.divein.network.CustomPacket;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Minecraft.class}, priority=500)
public class ClientPacketSenderMixin {
    @Shadow
    @Nullable
    public LocalPlayer f_91074_;
    @Shadow
    @Nullable
    public ClientLevel f_91073_;
    @Unique
    private boolean divein_1_20_1_forge$waterDrop;
    @Unique
    private boolean divein_1_20_1_forge$lavaDrop;

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        if (this.f_91074_ == null) {
            return;
        }
        this.divein_1_20_1_forge$waterDrop = Divein.checkWaterBelow((Player)this.f_91074_, Config.fluidLevelDetectHeight);
        this.divein_1_20_1_forge$lavaDrop = Divein.checkLavaBelow((Player)this.f_91074_, Config.fluidLevelDetectHeight * 2);
        if ((this.divein_1_20_1_forge$waterDrop || this.divein_1_20_1_forge$lavaDrop) && this.f_91074_.m_20184_().f_82480_ < 0.0) {
            this.divein_1_20_1_forge$tryPlayAnimationOnServerside();
        }
    }

    @Unique
    private void divein_1_20_1_forge$tryPlayAnimationOnServerside() {
        boolean isFalling;
        Minecraft client = (Minecraft)this;
        if (this.f_91074_ == null || client.m_91104_()) {
            return;
        }
        boolean hasRes = this.f_91074_.m_21023_(MobEffects.f_19607_);
        float sensitivity = (float)Config.triggerSensitivity;
        if (sensitivity < 0.0f) {
            sensitivity = 0.0f;
        }
        if (sensitivity > 1.0f) {
            sensitivity = 1.0f;
        }
        boolean bl = isFalling = this.f_91074_.m_20184_().f_82480_ < (double)(sensitivity - 1.0f) && !this.f_91074_.m_20096_() && (Objects.requireNonNull(client.f_91073_).m_8055_(this.f_91074_.m_20183_().m_7495_()).m_60713_(Blocks.f_50016_) || Objects.requireNonNull(client.f_91073_).m_8055_(this.f_91074_.m_20183_().m_7495_()).m_60713_(Blocks.f_50627_)) && !this.f_91074_.m_150110_().f_35935_;
        if (isFalling) {
            AnimationEffect.Visuals visuals;
            if (this.divein_1_20_1_forge$waterDrop || hasRes) {
                visuals = new AnimationEffect.Visuals("dive", AnimationEffect.Particles.DIVE);
                CustomPacket.sendToServer(this.f_91074_.m_19879_(), "dive", this.f_91074_.m_20184_().m_252839_());
                AnimationEffect.playVisuals(visuals, (Player)this.f_91074_, this.f_91074_.m_20184_());
            }
            if (this.divein_1_20_1_forge$lavaDrop) {
                visuals = new AnimationEffect.Visuals("lava_dive", AnimationEffect.Particles.DIVE);
                CustomPacket.sendToServer(this.f_91074_.m_19879_(), "lava_dive", this.f_91074_.m_20184_().m_252839_());
                AnimationEffect.playVisuals(visuals, (Player)this.f_91074_, this.f_91074_.m_20184_());
            }
        }
    }
}

