/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.divein.network;

import com.moigferdsrte.divein.extension.AnimationEffect;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.joml.Vector3f;

public record CustomPacket(int playerId, String animationName, Vector3f vec) {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("divein", "main"), () -> "1", "1"::equals, "1"::equals);
    public static int id = 0;

    public static void register() {
        INSTANCE.registerMessage(id++, CustomPacket.class, CustomPacket::encode, CustomPacket::decode, CustomPacket::handleOnServer);
    }

    private static void handleOnServer(CustomPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                ServerLevel level = (ServerLevel)sender.m_9236_();
                level.m_8795_(player -> player.m_19879_() != sender.m_19879_()).forEach(player -> INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CustomPacket(packet.playerId, packet.animationName, packet.vec)));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handleOnClient(CustomPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> CustomPacket.lambda$handleOnClient$6(packet, (Supplier)ctx)));
        ctx.get().setPacketHandled(true);
    }

    private static void handleClientPacket(CustomPacket packet, Supplier<NetworkEvent.Context> ctx) {
        Entity entity;
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ != null && (entity = client.f_91073_.m_6815_(packet.playerId)) instanceof Player) {
            Player player = (Player)entity;
            AnimationEffect.playVisuals(new AnimationEffect.Visuals(packet.animationName, AnimationEffect.Particles.DIVE), player, new Vec3((double)packet.vec.x, (double)packet.vec.y, (double)packet.vec.z));
        }
    }

    public static CustomPacket decode(FriendlyByteBuf passedData) {
        return new CustomPacket(passedData.readInt(), passedData.m_130277_(), passedData.m_269394_());
    }

    public void encode(FriendlyByteBuf passedData) {
        passedData.writeInt(this.playerId);
        passedData.m_130070_(this.animationName);
        passedData.m_269582_(this.vec);
    }

    public static void sendToServer(int playerId, String animationName, Vector3f vec) {
        INSTANCE.sendToServer((Object)new CustomPacket(playerId, animationName, vec));
    }

    private static /* synthetic */ Runnable lambda$handleOnClient$6(CustomPacket packet, Supplier ctx) {
        return () -> CustomPacket.lambda$handleOnClient$5(packet, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handleOnClient$5(CustomPacket packet, Supplier ctx) {
        CustomPacket.handleClientPacket(packet, ctx);
    }
}

