/*
 * Decompiled with CFR 0.152.
 */
package org.moigferdsrte;

import com.mojang.logging.LogUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.moigferdsrte.Config;
import org.moigferdsrte.DiveinClient;
import org.moigferdsrte.event.TriggerEventHandler;
import org.moigferdsrte.network.DiveinPosePayload;
import org.slf4j.Logger;

@Mod(value="divein")
@EventBusSubscriber(modid="divein")
public class Divein {
    public static final String MODID = "divein";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Divein(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.addListener(TriggerEventHandler::onPlayerFall);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.executesOn(HandlerThread.NETWORK).playBidirectional(DiveinPosePayload.TYPE, DiveinPosePayload.CODEC, (IPayloadHandler)new DirectionalPayloadHandler(Divein::handleDataOnNetworkClient, Divein::handleDataOnNetworkServer));
    }

    public static void handleDataOnNetworkServer(DiveinPosePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0])).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"divein.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void handleDataOnNetworkClient(DiveinPosePayload payload, IPayloadContext context) {
        Player localPlayer = context.player();
        context.enqueueWork(() -> {
            if (!localPlayer.getUUID().equals(payload.uuid())) {
                DiveinClient.playDiveAnimation(payload.uuid(), payload.isWater());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"divein.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

