/*
 * Decompiled with CFR 0.152.
 */
package org.moigferdsrte.event;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.moigferdsrte.Config;
import org.moigferdsrte.DiveinClient;
import org.moigferdsrte.network.DiveinPosePayload;

public class TriggerEventHandler {
    private static boolean hasTriggeredDive = false;
    static double sensitivity = Config.triggerSensitivity;

    @SubscribeEvent
    public static void onPlayerFall(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof Player) {
            boolean isFalling;
            Player player2 = player;
            Level level = event.getEntity().level();
            boolean bl = isFalling = player2.getDeltaMovement().y < sensitivity - 1.0 && !player2.onGround() && level.getBlockState(player2.blockPosition().below()).is(BlockTags.AIR) && !player2.getAbilities().flying;
            if (!player2.level().isClientSide() || !isFalling) {
                return;
            }
            boolean isWaterBelow = TriggerEventHandler.checkWaterBelow(player2, Config.fluidLevelDetectHeight);
            boolean isLavaBelow = TriggerEventHandler.checkLavaBelow(player2, Config.fluidLevelDetectHeight * 2);
            if (!hasTriggeredDive) {
                hasTriggeredDive = true;
                if (isWaterBelow) {
                    DiveinClient.playDiveAnimation(true);
                    if (player2.level().isClientSide()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new DiveinPosePayload(player2.getUUID(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                } else if (isLavaBelow) {
                    DiveinClient.playDiveAnimation(false);
                    if (player2.level().isClientSide()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new DiveinPosePayload(player2.getUUID(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            }
            if (!(isFalling && isWaterBelow && isLavaBelow)) {
                hasTriggeredDive = false;
            }
        }
    }

    private static boolean checkWaterBelow(Player player, int blocks) {
        if (player.isInWater()) {
            return true;
        }
        for (int i = 1; i <= blocks; ++i) {
            if (player.level().getBlockState(player.blockPosition().below(i)).getFluidState().getType() == Fluids.WATER && player.level().getBlockState(player.blockPosition().below(i - 1)).is(BlockTags.AIR)) {
                return true;
            }
            if (!player.level().getBlockState(player.blockPosition().below(i)).is(BlockTags.AIR)) break;
        }
        return false;
    }

    private static boolean checkLavaBelow(Player player, int blocks) {
        if (player.isInLava()) {
            return true;
        }
        for (int i = 1; i <= blocks; ++i) {
            if (player.level().getBlockState(player.blockPosition().below(i)).getFluidState().getType() == Fluids.LAVA && player.level().getBlockState(player.blockPosition().below(i - 1)).is(BlockTags.AIR)) {
                return true;
            }
            if (!player.level().getBlockState(player.blockPosition().below(i)).is(BlockTags.AIR)) break;
        }
        return false;
    }
}

