/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.divein.extension;

import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.Optional;
import java.util.function.Function;

public final class AdjustmentModifier
extends AbstractModifier {
    public boolean enabled = true;
    private Function<String, Optional<PartModifier>> source;

    public AdjustmentModifier(Function<String, Optional<PartModifier>> source) {
        this.source = source;
    }

    private float getFadeIn(float delta) {
        float fadeIn = 1.0f;
        IAnimation iAnimation = this.getAnim();
        if (iAnimation instanceof KeyframeAnimationPlayer) {
            KeyframeAnimationPlayer player = (KeyframeAnimationPlayer)iAnimation;
            float currentTick = (float)player.getTick() + delta;
            fadeIn = currentTick / (float)player.getData().beginTick;
            fadeIn = Math.min(fadeIn, 1.0f);
        }
        return fadeIn;
    }

    private float getFadeOut(float delta) {
        float fadeOut = 1.0f;
        IAnimation iAnimation = this.getAnim();
        if (iAnimation instanceof KeyframeAnimationPlayer) {
            KeyframeAnimationPlayer player = (KeyframeAnimationPlayer)iAnimation;
            float currentTick = (float)player.getTick() + delta;
            float position = -1.0f * (currentTick - (float)player.getData().stopTick);
            float length = player.getData().stopTick - player.getData().endTick;
            if (length > 0.0f) {
                fadeOut = position / length;
                fadeOut = Math.min(fadeOut, 1.0f);
            }
        }
        return fadeOut;
    }

    public Vec3f get3DTransform(String modelName, TransformType type, float tickDelta, Vec3f value0) {
        if (!this.enabled) {
            return super.get3DTransform(modelName, type, tickDelta, value0);
        }
        Optional<PartModifier> partModifier = this.source.apply(modelName);
        Vec3f modifiedVector = value0;
        float fade = this.getFadeIn(tickDelta) * this.getFadeOut(tickDelta);
        if (partModifier.isPresent()) {
            modifiedVector = super.get3DTransform(modelName, type, tickDelta, modifiedVector);
            return this.transformVector(modifiedVector, type, partModifier.get(), fade);
        }
        return super.get3DTransform(modelName, type, tickDelta, value0);
    }

    private Vec3f transformVector(Vec3f vector, TransformType type, PartModifier partModifier, float fade) {
        switch (type) {
            case POSITION: {
                return vector.add(partModifier.offset);
            }
            case ROTATION: {
                return vector.add(partModifier.rotation.scale(fade));
            }
        }
        return vector;
    }

    public record PartModifier(Vec3f rotation, Vec3f offset) {
    }
}

