/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.porcupine.mob.porcupine;

import aquariusplayz.animalgarden.porcupine.mob.porcupine.ModMobAnimations;
import aquariusplayz.animalgarden.porcupine.mob.porcupine.ModMobRenderState;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ModMobModel
extends EntityModel<ModMobRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_porcupine", (String)"porcupine"), "main");
    public static final ModelLayerLocation BABY_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_porcupine", (String)"baby_porcupine"), "main");
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(Set.of("head"));
    private final ModelPart rootz;
    private final ModelPart head;
    private final ModelPart leftear;
    private final ModelPart righear;
    private final ModelPart righteyelid;
    private final ModelPart lefteyelid;
    private final ModelPart headneedles;
    private final ModelPart headneedles1;
    private final ModelPart headneedles2;
    private final ModelPart headneedles3;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart tailneedles;
    private final ModelPart tailneedles1;
    private final ModelPart tailneedles2;
    private final ModelPart tailneedles3;
    private final ModelPart leftfrontleg;
    private final ModelPart rightfrontleg;
    private final ModelPart lefthindleg;
    private final ModelPart righthindleg;
    private final ModelPart bodyneedles;
    private final ModelPart needles1;
    private final ModelPart needles2;
    private final ModelPart needles3;
    private final ModelPart needles4;
    private final ModelPart needles5;
    private final ModelPart mainbody;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public ModMobModel(ModelPart root) {
        super(root);
        this.rootz = root.getChild("rootz");
        this.head = this.rootz.getChild("head");
        this.leftear = this.head.getChild("leftear");
        this.righear = this.head.getChild("righear");
        this.righteyelid = this.head.getChild("righteyelid");
        this.lefteyelid = this.head.getChild("lefteyelid");
        this.headneedles = this.head.getChild("headneedles");
        this.headneedles1 = this.headneedles.getChild("headneedles1");
        this.headneedles2 = this.headneedles.getChild("headneedles2");
        this.headneedles3 = this.headneedles.getChild("headneedles3");
        this.body = this.rootz.getChild("body");
        this.tail = this.body.getChild("tail");
        this.tailneedles = this.tail.getChild("tailneedles");
        this.tailneedles1 = this.tailneedles.getChild("tailneedles1");
        this.tailneedles2 = this.tailneedles.getChild("tailneedles2");
        this.tailneedles3 = this.tailneedles.getChild("tailneedles3");
        this.leftfrontleg = this.body.getChild("leftfrontleg");
        this.rightfrontleg = this.body.getChild("rightfrontleg");
        this.lefthindleg = this.body.getChild("lefthindleg");
        this.righthindleg = this.body.getChild("righthindleg");
        this.bodyneedles = this.body.getChild("bodyneedles");
        this.needles1 = this.bodyneedles.getChild("needles1");
        this.needles2 = this.bodyneedles.getChild("needles2");
        this.needles3 = this.bodyneedles.getChild("needles3");
        this.needles4 = this.bodyneedles.getChild("needles4");
        this.needles5 = this.bodyneedles.getChild("needles5");
        this.mainbody = this.body.getChild("mainbody");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("rootz", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)1.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 49).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(67, 24).addBox(-4.0f, -2.0f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(67, 28).addBox(3.0f, -2.0f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(38, 53).addBox(-1.0f, -2.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(15, 61).addBox(-2.0f, -5.0f, -3.0f, 4.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)-5.0f));
        PartDefinition leftear = head.addOrReplaceChild("leftear", CubeListBuilder.create().texOffs(38, 57).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(34, 67).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-4.0f, (float)-2.0f));
        PartDefinition righear = head.addOrReplaceChild("righear", CubeListBuilder.create().texOffs(38, 49).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(67, 32).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-4.0f, (float)-2.0f));
        PartDefinition righteyelid = head.addOrReplaceChild("righteyelid", CubeListBuilder.create().texOffs(67, 35).addBox(-1.0f, 0.0f, 0.014f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.005f)), PartPose.offset((float)-2.0f, (float)-4.0f, (float)-3.01f));
        PartDefinition lefteyelid = head.addOrReplaceChild("lefteyelid", CubeListBuilder.create().texOffs(67, 38).addBox(-1.0f, 0.0f, 0.014f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.005f)), PartPose.offset((float)2.0f, (float)-4.0f, (float)-3.01f));
        PartDefinition headneedles = head.addOrReplaceChild("headneedles", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition headneedles1 = headneedles.addOrReplaceChild("headneedles1", CubeListBuilder.create().texOffs(46, 18).addBox(-1.0f, -10.25f, 3.5f, 2.0f, 6.0f, 8.0f, new CubeDeformation(-0.55f)), PartPose.offset((float)0.0f, (float)5.0f, (float)-7.0f));
        PartDefinition headneedles2 = headneedles.addOrReplaceChild("headneedles2", CubeListBuilder.create().texOffs(46, 33).addBox(-1.0f, -10.25f, 3.5f, 2.0f, 6.0f, 8.0f, new CubeDeformation(-0.55f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition headneedles3 = headneedles.addOrReplaceChild("headneedles3", CubeListBuilder.create().texOffs(46, 48).addBox(-1.0f, -10.25f, 3.5f, 2.0f, 6.0f, 8.0f, new CubeDeformation(-0.55f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(34, 61).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.0f, (float)-3.25f, (float)2.25f));
        PartDefinition tailneedles = tail.addOrReplaceChild("tailneedles", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)2.5f));
        PartDefinition tailneedles1 = tailneedles.addOrReplaceChild("tailneedles1", CubeListBuilder.create().texOffs(29, 0).addBox(-1.0f, -3.5f, -3.5f, 2.0f, 6.0f, 6.0f, new CubeDeformation(-0.75f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)1.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition tailneedles2 = tailneedles.addOrReplaceChild("tailneedles2", CubeListBuilder.create().texOffs(23, 49).addBox(-1.25f, -3.5f, -3.0f, 2.0f, 6.0f, 5.0f, new CubeDeformation(-0.75f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)0.5f, (float)-0.5236f, (float)-0.0436f, (float)-0.8727f));
        PartDefinition tailneedles3 = tailneedles.addOrReplaceChild("tailneedles3", CubeListBuilder.create().texOffs(0, 59).addBox(-1.0f, -3.15f, -3.0f, 2.0f, 6.0f, 5.0f, new CubeDeformation(-0.75f)), PartPose.offsetAndRotation((float)1.35f, (float)-1.0f, (float)0.25f, (float)-0.5236f, (float)0.0436f, (float)0.8727f));
        PartDefinition leftfrontleg = body.addOrReplaceChild("leftfrontleg", CubeListBuilder.create().texOffs(45, 63).addBox(-1.0f, -0.75f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)-2.25f, (float)-3.5f));
        PartDefinition rightfrontleg = body.addOrReplaceChild("rightfrontleg", CubeListBuilder.create().texOffs(54, 63).addBox(-1.0f, -0.75f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)-2.25f, (float)-3.5f));
        PartDefinition lefthindleg = body.addOrReplaceChild("lefthindleg", CubeListBuilder.create().texOffs(63, 63).addBox(-1.0f, -0.75f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)-2.25f, (float)1.5f));
        PartDefinition righthindleg = body.addOrReplaceChild("righthindleg", CubeListBuilder.create().texOffs(67, 18).addBox(-1.0f, -0.75f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)-2.25f, (float)1.5f));
        PartDefinition bodyneedles = body.addOrReplaceChild("bodyneedles", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.25f, (float)-0.25f));
        PartDefinition needles1 = bodyneedles.addOrReplaceChild("needles1", CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, -6.5f, -2.5f, 2.0f, 8.0f, 9.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.25f, (float)-1.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition needles2 = bodyneedles.addOrReplaceChild("needles2", CubeListBuilder.create().texOffs(23, 13).addBox(-1.5f, -6.5f, -2.5f, 2.0f, 8.0f, 9.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)1.75f, (float)-1.5f, (float)-1.25f, (float)-0.2182f, (float)0.0f, (float)0.1309f));
        PartDefinition needles3 = bodyneedles.addOrReplaceChild("needles3", CubeListBuilder.create().texOffs(23, 31).addBox(-1.0f, -6.5f, -2.5f, 2.0f, 8.0f, 9.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-1.25f, (float)-1.5f, (float)-1.25f, (float)-0.2182f, (float)0.0f, (float)-0.1309f));
        PartDefinition needles4 = bodyneedles.addOrReplaceChild("needles4", CubeListBuilder.create().texOffs(0, 31).addBox(-1.0f, -6.5f, -2.5f, 2.0f, 8.0f, 9.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-2.5f, (float)-1.5f, (float)-1.25f, (float)-0.3491f, (float)0.0f, (float)-0.3491f));
        PartDefinition needles5 = bodyneedles.addOrReplaceChild("needles5", CubeListBuilder.create().texOffs(46, 0).addBox(-1.0f, -6.5f, -2.5f, 2.0f, 8.0f, 9.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)2.5f, (float)-1.5f, (float)-1.25f, (float)-0.3491f, (float)0.0f, (float)0.3491f));
        PartDefinition mainbody = body.addOrReplaceChild("mainbody", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -1.1f, -7.75f, 6.0f, 4.0f, 8.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)-4.9f, (float)2.75f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(ModMobRenderState p_368486_) {
        super.setupAnim((Object)p_368486_);
        if (!p_368486_.isSitting) {
            if (p_368486_.walkAnimationSpeed > 0.002f && p_368486_.walkAnimationSpeed < 10.0f) {
                this.animateWalk(ModMobAnimations.walk_animation, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, 6.0f, 2.5f);
            } else {
                this.animate(p_368486_.idleAnimationState, ModMobAnimations.idle_animation, p_368486_.ageInTicks, 1.0f);
            }
            this.animate(p_368486_.winkAnimationState, ModMobAnimations.wink_animation, p_368486_.ageInTicks, 1.0f);
        } else {
            this.animate(p_368486_.sitAnimationState, ModMobAnimations.sit_animation, p_368486_.ageInTicks, 1.0f);
        }
    }

    protected void animate(AnimationState p_361867_, AnimationDefinition p_365477_, float p_361961_) {
        this.animate(p_361867_, p_365477_, p_361961_, 1.0f);
    }

    protected void animateWalk(AnimationDefinition p_363127_, float p_364817_, float p_364163_, float p_365350_, float p_365167_) {
        long i = (long)(p_364817_ * 50.0f * p_365350_);
        float f = Math.min(p_364163_ * p_365167_, 1.0f);
        ModMobModel.animate((Model)this, p_363127_, i, f, ANIMATION_VECTOR_CACHE);
    }

    protected void animate(AnimationState p_368871_, AnimationDefinition p_365491_, float p_363110_, float p_368202_) {
        p_368871_.ifStarted(p_368242_ -> ModMobModel.animate((Model)this, p_365491_, (long)((float)p_368242_.getTimeInMillis(p_363110_) * p_368202_), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    protected void applyStatic(AnimationDefinition p_369884_) {
        ModMobModel.animate((Model)this, p_369884_, 0L, 1.0f, ANIMATION_VECTOR_CACHE);
    }

    public static Optional<ModelPart> getAnyDescendantWithName(Model p_362391_, String p_363872_) {
        Stream stream = p_362391_.root().getAllParts().stream();
        return p_363872_.equals("root") ? Optional.of(p_362391_.root()) : stream.filter(p_364767_ -> p_364767_.hasChild(p_363872_)).findFirst().map(p_366385_ -> p_366385_.getChild(p_363872_));
    }

    public static void animate(Model p_362391_, AnimationDefinition p_232321_, long p_232322_, float p_232323_, Vector3f p_253861_) {
        float f = ModMobModel.getElapsedSeconds(p_232321_, p_232322_);
        for (Map.Entry entry : p_232321_.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = ModMobModel.getAnyDescendantWithName(p_362391_, (String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(p_232330_ -> list.forEach(p_288241_ -> {
                Keyframe[] akeyframe = p_288241_.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)akeyframe.length, p_232315_ -> f <= akeyframe[p_232315_].timestamp()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.timestamp();
                float f2 = j != i ? Mth.clamp((float)(f1 / (keyframe1.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe1.interpolation().apply(p_253861_, f2, akeyframe, i, j, p_232323_);
                p_288241_.target().apply(p_232330_, p_253861_);
            }));
        }
    }

    public static float getElapsedSeconds(AnimationDefinition p_232317_, long p_232318_) {
        float f = (float)p_232318_ / 1000.0f;
        return p_232317_.looping() ? f % p_232317_.lengthInSeconds() : f;
    }
}

