/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.configuration;

import java.lang.reflect.Field;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import mirsario.cameraoverhaul.CameraOverhaul;
import mirsario.cameraoverhaul.abstractions.TextAbstractions;
import mirsario.cameraoverhaul.configuration.Configuration;
import net.minecraft.class_310;
import net.minecraft.class_437;

public final class ConfigScreen {
    public static class_437 getConfigScreen(class_437 parentScreen) {
        return ConfigScreen.getConfigBuilder(parentScreen).build();
    }

    public static ConfigBuilder getConfigBuilder(class_437 parentScreen) {
        CameraOverhaul.LOGGER.info("Opening config screen.");
        if (parentScreen == null) {
            parentScreen = class_310.method_1551().field_1755;
        }
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parentScreen).setTitle(ConfigScreen.getText("cameraoverhaul.config.title")).transparentBackground().setSavingRunnable(Configuration::saveConfig);
        ConfigCategory general = builder.getOrCreateCategory(ConfigScreen.getText("cameraoverhaul.config.category.general"));
        try {
            ConfigScreen.addEntriesFromObject(builder, general, Configuration.get(), Configuration.getDefault());
        }
        catch (Exception e) {
            CameraOverhaul.LOGGER.trace((Object)e);
        }
        return builder;
    }

    private static void addEntriesFromObject(ConfigBuilder builder, ConfigCategory category, Object objCurrent, Object objDefault) throws IllegalAccessException {
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        for (Field field : objCurrent.getClass().getFields()) {
            String fieldName = field.getName();
            Class<?> fieldType = field.getType();
            String name = ConfigScreen.getText(Configuration.getNameKey(fieldName));
            String desc = ConfigScreen.getText(Configuration.getDescKey(fieldName));
            DoubleListEntry entry = null;
            if (!fieldType.isPrimitive()) {
                ConfigCategory thisCategory = builder.getOrCreateCategory(ConfigScreen.getText(ConfigScreen.jvmdowngrader$concat$addEntriesFromObject$1(field.getName())));
                ConfigScreen.addEntriesFromObject(builder, thisCategory, field.get(objCurrent), field.get(objDefault));
                continue;
            }
            if (fieldType == Double.TYPE) {
                entry = entryBuilder.startDoubleField(name, ((Double)field.get(objCurrent)).doubleValue()).setDefaultValue(((Double)field.get(objDefault)).doubleValue()).setTooltip(new String[]{desc}).setSaveConsumer(newValue -> ConfigScreen.trySetFieldValue(field, objCurrent, newValue)).build();
            } else if (fieldType == Boolean.TYPE) {
                entry = entryBuilder.startBooleanToggle(name, ((Boolean)field.get(objCurrent)).booleanValue()).setDefaultValue(((Boolean)field.get(objDefault)).booleanValue()).setTooltip(new String[]{desc}).setSaveConsumer(newValue -> ConfigScreen.trySetFieldValue(field, objCurrent, newValue)).build();
            }
            if (entry == null) continue;
            category.addEntry(entry);
        }
    }

    private static void trySetFieldValue(Field field, Object obj, Object value) {
        try {
            field.set(obj, value);
        }
        catch (Exception e) {
            CameraOverhaul.LOGGER.trace((Object)e);
        }
    }

    public static String getText(String key) {
        return TextAbstractions.getTextValue(key);
    }

    private static String jvmdowngrader$concat$addEntriesFromObject$1(String string) {
        return "cameraoverhaul.config.category." + string;
    }
}

