/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.mixins;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mirsario.cameraoverhaul.CameraOverhaul;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXINS_PACKAGE = "mirsario.cameraoverhaul.mixins";
    private static final String[] MIXINS = new String[]{"CameraMixin", "ExplosionMixin", "GameRendererMixin", "LightningBoltMixin", "LocalPlayerMixin"};

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void onLoad(String mixinPackage) {
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public List<String> getMixins() {
        ArrayList<String> list = new ArrayList<String>();
        for (String mixin : MIXINS) {
            String mixinClassName = MixinPlugin.jvmdowngrader$concat$getMixins$1(mixin);
            try {
                Class.forName(mixinClassName, false, this.getClass().getClassLoader());
                CameraOverhaul.LOGGER.debug("Applying present mixin: '{}'.", (Object)mixinClassName);
                list.add(mixin);
            }
            catch (ClassNotFoundException ignored) {
                CameraOverhaul.LOGGER.debug("Skipping missing mixin: '{}'.", (Object)mixinClassName);
            }
        }
        return list;
    }

    private static String jvmdowngrader$concat$getMixins$1(String string) {
        return "mirsario.cameraoverhaul.mixins." + string;
    }
}

