/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.configuration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import mirsario.cameraoverhaul.CameraOverhaul;
import mirsario.cameraoverhaul.abstractions.TextAbstractions;
import mirsario.cameraoverhaul.configuration.ConfigData;
import mirsario.cameraoverhaul.shadow.com.moandjiezana.toml.Toml;
import net.fabricmc.loader.api.FabricLoader;

public final class Configuration {
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final Path CONFIG_PATH = CONFIG_DIR.resolve("cameraoverhaul.toml");
    private static final String CONFIG_ENTRIES_PREFIX = "cameraoverhaul.config";
    private static final Toml TOML = new Toml();
    private static final ConfigData configDefault = new ConfigData();
    private static ConfigData configCurrent;

    public static ConfigData getDefault() {
        return configDefault;
    }

    public static ConfigData get() {
        if (configCurrent == null) {
            Configuration.loadConfig();
        }
        return configCurrent;
    }

    public static void loadConfig() {
        File file = CONFIG_PATH.toFile();
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            configCurrent = file.exists() ? TOML.read(file).to(ConfigData.class) : new ConfigData();
        }
        catch (Exception e) {
            configCurrent = new ConfigData();
            CameraOverhaul.LOGGER.error("Failed to load config file", (Throwable)e);
        }
        Configuration.saveConfig();
    }

    public static void saveConfig() {
        Configuration.configCurrent.configVersion = 2;
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            Configuration.writeCommentedFieldsToml(writer, configCurrent, configDefault, 0);
        }
        catch (Exception e) {
            CameraOverhaul.LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    public static String getNameKey(String identifier) {
        return Configuration.jvmdowngrader$concat$getNameKey$1(identifier);
    }

    public static String getDescKey(String identifier) {
        return Configuration.jvmdowngrader$concat$getDescKey$1(identifier);
    }

    private static void writeCommentedFieldsToml(BufferedWriter writer, Object objCurrent, Object objDefault, int indentation) throws IllegalAccessException, IOException {
        for (Field field : objCurrent.getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (!field.getType().isPrimitive() && field.getType() != String.class) {
                writer.write("\r\n");
                writer.write("[");
                writer.write(field.getName());
                writer.write("]");
                writer.write("\r\n");
                writer.write("\r\n");
                Configuration.writeCommentedFieldsToml(writer, field.get(objCurrent), field.get(objDefault), indentation + 1);
                continue;
            }
            Configuration.indent(writer, indentation);
            writer.write("# ");
            writer.write(TextAbstractions.getTextValue(Configuration.getDescKey(field.getName())));
            Configuration.newLine(writer, indentation);
            writer.write("# Default: ");
            writer.write(field.get(objDefault).toString());
            Configuration.newLine(writer, indentation);
            writer.write(field.getName());
            writer.write(" = ");
            writer.write(field.get(objCurrent).toString());
            Configuration.newLine(writer, 0);
        }
    }

    private static void indent(BufferedWriter writer, int indentation) throws IOException {
        for (int i = 0; i < indentation; ++i) {
            writer.write("\t");
        }
    }

    private static void newLine(BufferedWriter writer, int indentation) throws IOException {
        writer.write("\r\n");
        Configuration.indent(writer, indentation);
    }

    private static String jvmdowngrader$concat$getNameKey$1(String string) {
        return "cameraoverhaul.config." + string + ".name";
    }

    private static String jvmdowngrader$concat$getDescKey$1(String string) {
        return "cameraoverhaul.config." + string + ".desc";
    }
}

