/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul;

import mirsario.cameraoverhaul.CameraContext;
import mirsario.cameraoverhaul.ScreenShakes;
import mirsario.cameraoverhaul.TimeSystem;
import mirsario.cameraoverhaul.configuration.ConfigData;
import mirsario.cameraoverhaul.configuration.Configuration;
import mirsario.cameraoverhaul.shadow.org.joml.SimplexNoise;
import mirsario.cameraoverhaul.shadow.org.joml.Vector3d;
import mirsario.cameraoverhaul.utilities.MathUtils;
import mirsario.cameraoverhaul.utilities.Transform;

public final class CameraSystem {
    private ConfigData cfg;
    private ConfigData.Contextual ctxCfg;
    private final Vector3d prevCameraEulerRot = new Vector3d();
    private final Vector3d prevEntityVelocity = new Vector3d();
    private double lastActionTime;
    private CameraContext.Perspective prevCameraPerspective;
    private final Transform offsetTransform = new Transform();
    private static final double BASE_VERTICAL_PITCH_SMOOTHING = 4.0E-5;
    private double prevVerticalVelocityPitchOffset;
    private static final double BASE_FORWARD_PITCH_SMOOTHING = 0.008;
    private double prevForwardVelocityPitchOffset;
    private static final double BASE_TURNING_ROLL_ACCUMULATION = 0.0048;
    private static final double BASE_TURNING_ROLL_INTENSITY = 1.25;
    private static final double BASE_TURNING_ROLL_SMOOTHING = 0.0825;
    private double turningRollTargetOffset;
    private static final double BASE_STRAFING_ROLL_SMOOTHING = 0.008;
    private double prevStrafingRollOffset;
    private static final double CAMERASWAY_FADING_SMOOTHNESS = 3.0;
    private double cameraSwayFactor;
    private double cameraSwayFactorTarget;

    public void notifyOfPlayerAction() {
        this.lastActionTime = TimeSystem.getTime();
    }

    public void onCameraUpdate(CameraContext context, double deltaTime) {
        double time = TimeSystem.getTime();
        this.cfg = Configuration.get();
        this.ctxCfg = context.isRidingVehicle ? this.cfg.vehicles : (context.isRidingMount ? this.cfg.mounts : (context.isSwimming ? this.cfg.swimming : (context.isFlying ? this.cfg.flying : this.cfg.walking)));
        this.offsetTransform.position = new Vector3d(0.0, 0.0, 0.0);
        this.offsetTransform.eulerRot = new Vector3d(0.0, 0.0, 0.0);
        if (!this.cfg.general.enabled || !this.cfg.general.enableInThirdPerson && context.perspective != CameraContext.Perspective.FIRST_PERSON) {
            return;
        }
        ScreenShakes.onCameraUpdate(context, deltaTime);
        if (!context.velocity.equals(this.prevEntityVelocity) || !context.transform.eulerRot.equals(this.prevCameraEulerRot)) {
            this.notifyOfPlayerAction();
        }
        this.verticalVelocityPitchOffset(context, this.offsetTransform, deltaTime);
        this.forwardVelocityPitchOffset(context, this.offsetTransform, deltaTime);
        this.turningRollOffset(context, this.offsetTransform, deltaTime);
        this.strafingRollOffset(context, this.offsetTransform, deltaTime);
        this.noiseOffset(context, this.offsetTransform, deltaTime);
        this.prevEntityVelocity.set(context.velocity);
        this.prevCameraEulerRot.set(context.transform.eulerRot);
        this.prevCameraPerspective = context.perspective;
    }

    public void modifyCameraTransform(Transform transform) {
        transform.position.add(this.offsetTransform.position);
        transform.eulerRot.add(this.offsetTransform.eulerRot);
        ScreenShakes.modifyCameraTransform(transform);
    }

    private void verticalVelocityPitchOffset(CameraContext context, Transform outputTransform, double deltaTime) {
        double multiplier = this.ctxCfg.verticalVelocityPitchFactor;
        double smoothing = 4.0E-5 * this.ctxCfg.verticalVelocitySmoothingFactor;
        double targetOffset = context.velocity.y * multiplier;
        double currentOffset = MathUtils.damp(this.prevVerticalVelocityPitchOffset, targetOffset, smoothing, deltaTime);
        outputTransform.eulerRot.x += currentOffset;
        this.prevVerticalVelocityPitchOffset = currentOffset;
    }

    private void forwardVelocityPitchOffset(CameraContext context, Transform outputTransform, double deltaTime) {
        double multiplier = this.ctxCfg.forwardVelocityPitchFactor;
        double smoothing = 0.008 * this.ctxCfg.horizontalVelocitySmoothingFactor;
        double targetOffset = context.getForwardRelativeVelocity().z * multiplier;
        double currentOffset = MathUtils.damp(this.prevForwardVelocityPitchOffset, targetOffset, smoothing, deltaTime);
        outputTransform.eulerRot.x += currentOffset;
        this.prevForwardVelocityPitchOffset = currentOffset;
    }

    private void turningRollOffset(CameraContext context, Transform outputTransform, double deltaTime) {
        double decaySmoothing = 0.0825 * this.cfg.general.turningRollSmoothing;
        double intensity = 1.25 * this.cfg.general.turningRollIntensity;
        double accumulation = 0.0048 * this.cfg.general.turningRollAccumulation;
        double yawDelta = this.prevCameraEulerRot.y - context.transform.eulerRot.y;
        if (context.perspective != this.prevCameraPerspective) {
            yawDelta = 0.0;
        }
        this.turningRollTargetOffset = MathUtils.damp(this.turningRollTargetOffset, 0.0, decaySmoothing, deltaTime);
        this.turningRollTargetOffset = MathUtils.clamp(this.turningRollTargetOffset + yawDelta * accumulation, -1.0, 1.0);
        double turningRollOffset = MathUtils.clamp01(CameraSystem.turningEasing(Math.abs(this.turningRollTargetOffset))) * intensity * Math.signum(this.turningRollTargetOffset);
        outputTransform.eulerRot.z += turningRollOffset;
    }

    private static double turningEasing(double x) {
        return x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0;
    }

    private void strafingRollOffset(CameraContext context, Transform outputTransform, double deltaTime) {
        double multiplier = this.ctxCfg.strafingRollFactor;
        double smoothing = 0.008 * this.ctxCfg.horizontalVelocitySmoothingFactor;
        double target = -context.getForwardRelativeVelocity().x * multiplier;
        double offset = MathUtils.damp(this.prevStrafingRollOffset, target, smoothing, deltaTime);
        outputTransform.eulerRot.z += offset;
        this.prevStrafingRollOffset = offset;
    }

    private void noiseOffset(CameraContext context, Transform outputTransform, double deltaTime) {
        double time = TimeSystem.getTime();
        float noiseX = (float)(time * this.cfg.general.cameraSwayFrequency);
        if (time - this.lastActionTime < this.cfg.general.cameraSwayFadeInDelay) {
            this.cameraSwayFactorTarget = 0.0;
        } else if (this.cameraSwayFactor == this.cameraSwayFactorTarget) {
            this.cameraSwayFactorTarget = 1.0;
        }
        double cameraSwayFactorFadeLength = this.cameraSwayFactorTarget > 0.0 ? this.cfg.general.cameraSwayFadeInLength : this.cfg.general.cameraSwayFadeOutLength;
        double cameraSwayFactorFadeStep = cameraSwayFactorFadeLength > 0.0 ? deltaTime / cameraSwayFactorFadeLength : 1.0;
        this.cameraSwayFactor = MathUtils.stepTowards(this.cameraSwayFactor, this.cameraSwayFactorTarget, cameraSwayFactorFadeStep);
        double scaledIntensity = this.cfg.general.cameraSwayIntensity * Math.pow(this.cameraSwayFactor, 3.0);
        Vector3d target = new Vector3d(scaledIntensity, scaledIntensity, 0.0);
        Vector3d noise = new Vector3d(SimplexNoise.noise(noiseX, 420.0f), SimplexNoise.noise(noiseX, 1337.0f), SimplexNoise.noise(noiseX, 6969.0f));
        outputTransform.eulerRot.add(noise.mul(target));
    }
}

