/*
 * Decompiled with CFR 0.152.
 */
package me.anticode.astro_reforged.entity;

import gravity_changer.api.GravityChangerAPI;
import java.util.ArrayList;
import java.util.List;
import me.anticode.astro_reforged.api.AstroEntityInterface;
import me.anticode.astro_reforged.init.AstroEntities;
import me.anticode.astro_reforged.init.AstroItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class GravityBombEntity
extends class_3857 {
    private boolean hasLanded = false;
    private final int bomb_duration = 200;
    private int active_duration = 0;
    private List<class_1297> moddedEntities = new ArrayList<class_1297>();
    protected GravityBombType gravityBombType = GravityBombType.HIGH;

    public GravityBombEntity(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
        GravityChangerAPI.setBaseGravityStrength((class_1297)this, (double)0.5);
    }

    public GravityBombEntity(GravityBombType gravityBombType, class_1937 world, class_1309 owner) {
        super(switch (gravityBombType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> AstroEntities.HIGH_GRAVITY_BOMB;
            case 1 -> AstroEntities.LOW_GRAVITY_BOMB;
            case 2 -> AstroEntities.LOW_GRAVITY_BOMB;
        }, owner, world);
        this.gravityBombType = gravityBombType;
        GravityChangerAPI.setBaseGravityStrength((class_1297)this, (double)0.5);
    }

    protected class_1792 method_16942() {
        return AstroItems.HIGH_GRAVITY_BOMB;
    }

    @Environment(value=EnvType.CLIENT)
    private class_2394 getParticleEffect() {
        return new class_2388(class_2398.field_11217, class_2246.field_27161.method_9564());
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte status) {
        block4: {
            class_2394 particleEffect;
            block5: {
                block3: {
                    particleEffect = this.getParticleEffect();
                    if (status != 3) break block3;
                    for (int i = 0; i < 32; ++i) {
                        this.method_37908().method_8406(particleEffect, this.method_23317() + (this.field_5974.method_43058() - 0.5) * 4.0, this.method_23318(), this.method_23321() + (this.field_5974.method_43058() - 0.5) * 4.0, this.field_5974.method_43059(), 0.0, this.field_5974.method_43059());
                    }
                    break block4;
                }
                if (status != 5) break block5;
                for (int i = 0; i < 32; ++i) {
                    this.method_37908().method_8406(particleEffect, this.method_23317() + (this.field_5974.method_43058() - 0.5) * 20.0, this.method_23318() + (this.field_5974.method_43058() - 0.5) * 20.0, this.method_23321() + (this.field_5974.method_43058() - 0.5) * 20.0, 0.0, 0.0, 0.0);
                }
                break block4;
            }
            if (status != 10) break block4;
            for (int i = 0; i < 32; ++i) {
                this.method_37908().method_8406(particleEffect, this.method_23317() + (this.field_5974.method_43058() - 0.5) * 2.0, this.method_23318(), this.method_23321() + (this.field_5974.method_43058() - 0.5) * 2.0, this.field_5974.method_43059(), this.field_5974.method_43058(), this.field_5974.method_43059());
            }
        }
    }

    public void method_5773() {
        if (this.hasLanded() && !this.method_37908().method_8608()) {
            ++this.active_duration;
            this.method_37908().method_8421((class_1297)this, (byte)5);
            List nearbyEntities = this.method_37908().method_8335((class_1297)this, class_238.method_30048((class_243)this.method_19538(), (double)20.0, (double)20.0, (double)20.0));
            List<class_1297> unmodifiedEntities = nearbyEntities.stream().filter(entity -> !this.moddedEntities.contains(entity)).toList();
            List<class_1297> oldModifiedEntities = this.moddedEntities.stream().filter(entity -> !nearbyEntities.contains(entity)).toList();
            for (class_1297 entity2 : oldModifiedEntities) {
                ((AstroEntityInterface)entity2).astroReforged$removeGravityBombModifier(this.method_5667());
                this.moddedEntities.remove(entity2);
            }
            for (class_1297 entity2 : unmodifiedEntities) {
                switch (this.gravityBombType.ordinal()) {
                    case 0: {
                        ((AstroEntityInterface)entity2).astroReforged$setGravityBombModifier(8.0, this.method_5667());
                        break;
                    }
                    case 1: {
                        ((AstroEntityInterface)entity2).astroReforged$setGravityBombModifier(0.3, this.method_5667());
                        break;
                    }
                    case 2: {
                        ((AstroEntityInterface)entity2).astroReforged$setGravityBombModifier(-0.1, this.method_5667());
                    }
                }
                this.moddedEntities.add(entity2);
            }
            if (this.active_duration >= 200) {
                this.method_37908().method_8421((class_1297)this, (byte)10);
                for (class_1297 entity2 : this.moddedEntities) {
                    ((AstroEntityInterface)entity2).astroReforged$removeGravityBombModifier(this.method_5667());
                }
                this.method_31472();
            }
        }
        super.method_5773();
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }

    protected void method_24920(class_3965 blockHitResult) {
        class_1937 world = this.method_37908();
        if (!world.method_8608()) {
            world.method_8421((class_1297)this, (byte)3);
            this.land();
        }
        super.method_24920(blockHitResult);
    }

    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        if (entityHitResult.method_17782().method_5732()) {
            entityHitResult.method_17782().method_5643(this.method_37908().method_48963().method_48830(), 2.0f);
        }
        this.method_18799(this.method_18798().method_1021(-0.4));
    }

    public boolean hasLanded() {
        return this.hasLanded;
    }

    public void land() {
        this.method_18799(class_243.field_1353);
        GravityChangerAPI.setBaseGravityStrength((class_1297)this, (double)0.0);
        this.hasLanded = true;
    }

    public void method_5651(class_2487 nbt) {
        this.hasLanded = nbt.method_10577("hasLanded");
        this.active_duration = nbt.method_10550("active_duration");
        this.gravityBombType = GravityBombType.valueFromIndex(nbt.method_10550("bomb_type"));
        super.method_5651(nbt);
    }

    public class_2487 method_5647(class_2487 nbt) {
        nbt.method_10556("hasLanded", this.hasLanded);
        nbt.method_10569("active_duration", this.active_duration);
        nbt.method_10569("bomb_type", this.gravityBombType.getIndex());
        return super.method_5647(nbt);
    }

    public static enum GravityBombType {
        HIGH(0),
        LOW(1),
        ANTI(2);

        private final int index;

        private GravityBombType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static GravityBombType valueFromIndex(int index) {
            return GravityBombType.values()[index];
        }
    }
}

