/*
 * Decompiled with CFR 0.152.
 */
package me.anticode.astro_reforged.mixin;

import gravity_changer.api.GravityChangerAPI;
import java.util.HashMap;
import java.util.UUID;
import me.anticode.astro_reforged.api.AstroEntityInterface;
import me.anticode.astro_reforged.init.AstroAttributes;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_5132;
import net.puffish.attributesmod.api.DynamicModification;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements AstroEntityInterface {
    @Unique
    private final HashMap<UUID, Double> gravityModifiers = new HashMap();

    @Override
    public void astroReforged$setGravityBombModifier(double gravityModifier, UUID uuid) {
        this.gravityModifiers.putIfAbsent(uuid, gravityModifier);
    }

    @Override
    public void astroReforged$removeGravityBombModifier(UUID uuid) {
        this.gravityModifiers.remove(uuid);
    }

    @Inject(method={"createLivingAttributes"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void createLivingAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(AstroAttributes.GRAVITY_REDUCTION);
    }

    @Inject(method={"tickMovement"}, at={@At(value="HEAD")})
    private void tickMovement(CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        if (livingEntity.method_37908().method_8608()) {
            return;
        }
        double oldGravity = GravityChangerAPI.getGravityStrength((class_1297)livingEntity);
        double gravityModifierTotal = 1.0;
        for (double gravityModifier : this.gravityModifiers.values()) {
            gravityModifierTotal *= gravityModifier;
        }
        double gravityTarget = gravityModifierTotal;
        if (!livingEntity.method_5715()) {
            gravityTarget = DynamicModification.create().withNegative(AstroAttributes.GRAVITY_REDUCTION, livingEntity).applyTo(gravityModifierTotal);
        }
        if (gravityTarget != oldGravity) {
            GravityChangerAPI.setBaseGravityStrength((class_1297)livingEntity, (double)gravityTarget);
        }
    }
}

