#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightColor;
in vec2 texCoord0;
in vec2 texCoord1;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0);
    int alphaValue = int(round(color.a * 255.0));

    switch (alphaValue) {

        case 252:
            color.a = 1.0;
            break;

        default:
            color *= lightColor * vertexColor;
            break;

    }
    
    color *= ColorModulator;

    if (color.a < 0.1) {
        discard;
    }

    fragColor = linear_fog(
        color,
        vertexDistance,
        FogStart,
        FogEnd,
        FogColor
        );
}
