[![Fabric Mod](https://img.shields.io/badge/modloader-fabric-eeeeee)](https://fabricmc.net/use/)
[![Latest Version](https://img.shields.io/modrinth/v/MOqt4Z5n?color=blueviolet&label=latest%20version)](https://modrinth.com/mod/MOqt4Z5n)

[![Build Status](https://img.shields.io/endpoint.svg?url=https%3A%2F%2Factions-badge.atrox.dev%2Fmrbuilder1961%2FChatPatches%2Fbadge%3Fref%3D1.19.4&style=flat)](https://actions-badge.atrox.dev/mrbuilder1961/ChatPatches/goto?ref=1.20.x)
![GitHub code size](https://img.shields.io/github/languages/code-size/mrbuilder1961/ChatPatches)

[![Curseforge Download](https://cf.way2muchnoise.eu/full_560042_downloads.svg)](https://www.curseforge.com/minecraft/mc-mods/chatpatches)
[![Modrinth Download](https://img.shields.io/badge/dynamic/json?&color=242629&labelColor=5ca424&label=&suffix=%20downloads&query=downloads&url=https://api.modrinth.com/v2/project/MOqt4Z5n&cacheSeconds=3600&logo=data:image/svg+xml;base64,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)](https://www.modrinth.com/mod/MOqt4Z5n)
[![Join the Discord Server!](https://img.shields.io/discord/1077285607375638529?color=6262df&label=discord%20)](https://discord.gg/3MqBvNEyMz)
# Chat Patches (formerly Where's My Chat History)
### Requires [Yet Another Config Lib](https://modrinth.com/mod/yacl/versions?l=fabric&c=release) and [Mod Menu](https://modrinth.com/mod/modmenu/versions?l=fabric&c=release) for 1.19.2+

This mod does quite a few things:
- Increases the maximum amount of chat messages from 100 to 16,384
- Adds a timestamp in front of all messages, formatted as `[HOUR:MINUTE:SECOND]` in pink text, with a tooltip that renders a complete date
- Keeps chat history and previously sent messages across ALL worlds and servers
- Allows logging chat messages for restoring them later in future Minecraft sessions
- Lets you modify vanilla player names to anything you want (ex. without the triangle brackets!)
- Minimizes spam with a counter that shows how many duplicate messages have been sent in a row
- Shifts the chat hud up by 10 pixels, so it doesn't overlap with the armor bar
- Provides a menu to copy specific data (and the text of course!) from chat messages
- Lets you search through all received messages with a search bar
- All of this is configurable, with much more to offer!

This mod also provides features from a multitude of other mods, including:
- [More Chat History](https://www.curseforge.com/minecraft/mc-mods/more-chat-history)
- [When Was That Again](https://www.curseforge.com/minecraft/mc-mods/wwta)
- [Don't Clear Chat History](https://www.curseforge.com/minecraft/mc-mods/dont-clear-chat-history)
- [No Angled Brackets](https://www.curseforge.com/minecraft/mc-mods/no-angled-brackets)
- [Clear Spam](https://www.curseforge.com/minecraft/mc-mods/clearspam)
- [Chat Up!](https://www.curseforge.com/minecraft/mc-mods/chat-up)
- [Compact Chat](https://modrinth.com/mod/compact-chat)

Be on the lookout for new versions, issues, and future features!

## FAQ

- What Minecraft version can I use this with?
  - The *latest Fabric* versions of Minecraft, plus 1.18.x. *Quilt* appears to work, but I don't provide official support for it.
- Will you make it for (older Minecraft version)?
  - Not likely. The oldest version I'll be making is 1.18.x. Any older version would only be supported if it is generally recognized as a modding-LTS version and if it is commonly requested, because backporting is boring and makes me want to die.
- Will you make this for Forge?
  - Probably at some point after all the major changes I want to implement are finished. But right now, I doubt it. Fabric's API is simple, and I am too lazy to learn Forge's until then.
- I found a bug/issue, what do I do?
  - First, make sure you have the latest version of the mod for your Minecraft version. If it still persists,you can click on the Issues tab on this page, and nobody has opened one about your issue then create one! Note that a lack of provided information will increase time needed to fix.
- It says I need to install Fabric, but I already have it installed?
  - [Install the Fabric API.](https://modrinth.com/mod/fabric-api)
- Do servers need this mod?
  - It is client side, so no.
- I can't access the config menu in-game!
  - <u>For 1.19.2+:</u>
    - If you do not want to install Mod Menu, you can instead use [Catalogue](https://www.curseforge.com/minecraft/mc-mods/catalogue-fabric)
      with [Menulogue](https://www.curseforge.com/minecraft/mc-mods/menulogue), which will provide the same functionality!
    - Otherwise, if you still cannot access the config after ensuring YACL and a menu mod are installed, check for an error message and [open an
      issue on GitHub](https://github.com/mrbuilder1961/ChatPatches/issues/new/choose). If there isn't an error message, open an issue anyway and follow the instructions in the issue template.
  - <u>For 1.18.x:</u> You need the LATEST versions of both [Cloth Config](https://modrinth.com/mod/cloth-config/versions?l=fabric&c=release) and [Mod Menu](https://modrinth.com/mod/modmenu/versions?l=fabric&c=release) to access it in game.
  - <u>For all versions:</u> You can always edit the config at `(directory)/config/chatpatches.json`.
- My config is broken/not working!
  - When you load one of the more recent mod versions, it makes a creates a new file with your old settings and resets the main file. You can access this
    copy at `(directory)/config/chatpatches_old.json`. By then opening both the new and old configs at the same time, you can copy and paste over the values.
    Make sure the settings have correct inputs (ex. `time` should be `true`/`false` not `123` or `"true"`). If you still are having problems, open a new issue on GitHub.
- Can I use this in a modpack?
  - Yes, as long as you credit me and/or link back to one of the official pages (here, [CurseForge](https://www.curseforge.com/minecraft/mc-mods/chatpatches), and [Modrinth](https://modrinth.com/mod/chatpatches/versions)).
- Can I re-upload this mod elsewhere?
  - No, unless you have explicit permission from OBro1961, modify the mod in an undisputable way, or any download links used direct to one of the official
    pages (see above). If you're unsure, DM me (@obro1961) on Discord about it.
- How do I do X?
  - If the answer you're looking for isn't anywhere here or in the config, check the #Help section located below. If you still can't find it, ask in the Discord.

## Localization and Translation

If you would like to help translate Chat Patches into other languages, you can:
- [Create a pull request](https://github.com/mrbuilder1961/ChatPatches/compare) that adds, corrects, or updates a language file *(preferred)*
- [Create an issue on GitHub](https://github.com/mrbuilder1961/ChatPatches/issues/new) with the language file attached
- DM me on Discord (@obro1961)

Once you contribute, [join the Discord server](https://discord.gg/3MqBvNEyMz) so you can receive your Contributor and Translator roles!

## Setup devenv / Build latest jars

1. Download the latest ZIP (this page -> Code -> Download ZIP)
2. Extract it to your desired folder
3. Open a terminal/command prompt, then run `./gradlew build`
4. [For a devenv]: open the folder in your IDE
5. [For built jars]: navigate to `/build/libs/`

## Configuration help

| Name                          | Default Value    | Description                                                                                                                                                                                                                                                                                                                            | Lang Key                                  |
|-------------------------------|------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------|
| Timestamp toggle              | `true`           | Should a timestamp in front of all messages show?                                                                                                                                                                                                                                                                                      | `text.chatpatches.time`                   |
| Timestamp text                | `"HH:mm:ss"`     | The text that is formatted into a timestamp. See the Help > Date & Time Formatting section for more information.                                                                                                                                                                                                                       | `text.chatpatches.timeDate`               |
| Timestamp decoration text     | `"[$]"`          | The string of '&' + formatting code modifiers and decoration text that create the timestamp. The '$' is a placeholder for the formatted timestamp option above this one.                                                                                                                                                               | `text.chatpatches.timeFormat`             |
| Timestamp color               | `0xff55ff`       | The color that's filled in where it would otherwise be blank in the resulting timestamp. To use this with other formatting modifiers, use '&r' in the decoration text option.                                                                                                                                                          | `text.chatpatches.timeColor`              |
| Hover toggle                  | `true`           | Should text appear stating a more detailed time description when you hover over the timestamp text in chat?                                                                                                                                                                                                                            | `text.chatpatches.hover`                  |
| Hover text                    | `"MM/dd/yyyy"`   | The text that is formatted into a longer date/time string. See the Help > Date & Time Formatting section for more information.                                                                                                                                                                                                         | `text.chatpatches.hoverDate`              |
| Hover decoration text         | `"$"`            | The string of '&' + formatting code modifiers and decoration text that create the detailed hover description. Requires a '$' as a placeholder for the formatted timestamp option above this one.                                                                                                                                       | `text.chatpatches.hoverFormat`            |
| Hover text color              | `0xffffff`       | The color that's filled in where it would otherwise be blank white in the resulting hover text. To use this with other formatting modifiers, use '&r' in the decoration text option.                                                                                                                                                   | `text.chatpatches.hoverColor`             |
| Message counter toggle        | `true`           | Should a message counter show after messages to indicate multiple duplicates were sent? Note: this is required to be enabled for the CompactChat options to work.                                                                                                                                                                      | `text.chatpatches.counter`                |
| Message counter text          | `"&8(&7x&r$&8)"` | The text that's added to the end of a message to indicate multiple duplicates were sent. Requires a '$' for the number of duplicates, also supports '&' + formatting code modifiers. Still applies to the CompactChat method, if enabled.                                                                                              | `text.chatpatches.counterFormat`          |
| Message counter color         | `0xffff55`       | The color that's filled in where it would otherwise be blank white in the resulting duplicate counter. To use this with other formatting modifiers, use '&r' in the decoration text option. Still applies to the CompactChat method, if enabled.                                                                                       | `text.chatpatches.counterColor`           |
| Check formatting modifiers    | `false`          | Should the message counter check formatting modifiers when checking for duplicates? For example, "§e§labc§r" and "abc" would NOT be considered duplicates if true. Still applies to the CompactChat method, if enabled.                                                                                                                | `text.chatpatches.counterCheckStyle`      |
| CompactChat method toggle     | `false`          | Should the message counter behave like the one from the CompactChat mod?                                                                                                                                                                                                                                                               | `text.chatpatches.counterCompact`         |
| Message check distance        | `0`              | The distance (inclusive) up to which messages will be tried for compacting. Setting this to '-1' will try the entire message list, and '0' will try using the maximum amount of messages you can see at once. For example, setting this to '7' will try to compact the next message received into the last 7 messages already present. | `text.chatpatches.counterCompactDistance` |
| Boundary toggle               | `true`           | Should a boundary line show after chatting, leaving a world/server, and then joining another world/server later?                                                                                                                                                                                                                       | `text.chatpatches.boundary`               |
| Boundary text                 | `"&8[&r$&8]"`    | The text that is formatted and used for the boundary line. Supports '&' + formatting code modifiers, '\n' for new lines, and using '$' as a placeholder for the world name.                                                                                                                                                            | `text.chatpatches.boundaryFormat`         |
| Boundary color                | `0x55ffff`       | The color that's filled in where it would otherwise be blank white in the resulting boundary line. To use this with other formatting modifiers, use '&r' in the decoration text option.                                                                                                                                                | `text.chatpatches.boundaryColor`          |
| Chat Log toggle               | `true`           | Should the chat be saved into a log so it can be re-added back into the chat in later game sessions?                                                                                                                                                                                                                                   | `text.chatpatches.chatlog`                |
| Save interval (minutes)       | `0`              | How long should the Chat Log wait before saving to disk? This is in minutes, the minimum is 1. Set to 0 to only save when paused (warning: setting to <5 will lag a lot). All values try to save during crashes, and all save on game exit.                                                                                            | `text.chatpatches.chatlogSaveInterval`    |
| Ignore hide message packet    | `true`           | Should hide message packets that delete chat messages be ignored?                                                                                                                                                                                                                                                                      | `text.chatpatches.chatHidePacket`         |
| Override chat width           | `0`              | The width of the chat box. This overrides vanilla's default and allows for a much larger width. Set to 0 to use the vanilla setting and not override it.                                                                                                                                                                               | `text.chatpatches.chatWidth`              |
| Override chat height          | `0`              | The height of the chat box. This overrides vanilla's default and allows for a much larger height. Set to 0 to use the vanilla setting and not override it.                                                                                                                                                                             | `text.chatpatches.chatHeight`             |
| Maximum chat messages         | `16384`          | The max amount of chat messages allowed to save. Vanilla caps it at 100, this mod can increase it up to 32,767. Keep in mind a higher max equals higher memory usage.                                                                                                                                                                  | `text.chatpatches.chatMaxMessages`        |
| Playername text toggle        | `true`           | Should the playername be modified in chat messages? Turning this off will make the playername appear as it does in vanilla, and disable both of the following options. Toggle this if you have conflicting plugins that modify the playername in chat.                                                                                 | `text.chatpatches.chatName`               |
| Playername text               | `"<$>"`          | The text that replaces the playername in chat messages. Vanilla is '<$>', name only is '$'; where '$' is a placeholder for the playername. Only applies to player-sent messages.                                                                                                                                                       | `text.chatpatches.chatNameFormat`         |
| Playername color              | `0xffffff`       | The color that's filled in where it would otherwise be blank white in the resulting formatted playername. To use this with other formatting modifiers, use '&r' in the decoration text option.                                                                                                                                         | `text.chatpatches.chatNameColor`          |
| Chat shift offset             | `0`              | Shifts the chat interface according to the provided value (negative values shift downward). Default is 0 with dynamic shift enabled; to emulate vanilla behavior make sure to disable dynamic shift.                                                                                                                                   | `text.chatpatches.chatShift`              |
| Dynamic chat shifting         | `true`           | Should the chat be shifted dynamically based on armor and health? If disabled, the chat is simply shifted according to the chat shifting constant.                                                                                                                                                                                     | `text.chatpatches.dynamicChatShift`       |
| Chat drafting toggle          | `false`          | Should any text in the chat field persist after closing and reopening the chat?                                                                                                                                                                                                                                                        | `text.chatpatches.messageDrafting`        |
| Only invasive drafting toggle | `false`          | Should the text in the chat field only persist when chat is closed unexpectedly? For example when chat is closed by the server opening a GUI, the player is moved to another dimension, or the player dies.                                                                                                                            | `text.chatpatches.onlyInvasiveDrafting`   |
| Search drafting toggle        | `true`           | Should any text in the search field persist after closing and reopening the chat?                                                                                                                                                                                                                                                      | `text.chatpatches.searchDrafting`         |
| Hide search button            | `false`          | Should the search button be hidden? Note that this disables all search functionality.                                                                                                                                                                                                                                                  | `text.chatpatches.hideSearchButton`       |
| Vanilla chat clearing         | `false`          | Should chat messages clear after leaving a world/server like vanilla? Note this completely erases both the chat and chat log.                                                                                                                                                                                                          | `text.chatpatches.vanillaClearing`        |
| Message selection color       | `0x55ffff`       | The color of the selection box that's shown after right-clicking on a chat message.                                                                                                                                                                                                                                                    | `text.chatpatches.copyColor`              |
| Reply text format             | `"/msg $ "`      | The text that is filled into the chat box after right-clicking on a chat message and clicking on the 'Reply' button in the copy menu. '$' is required and will be filled with the message sender's name.                                                                                                                               | `text.chatpatches.copyReplyFormat`        |
| Case sensitive                | `true`           | Should the search query only match text with the same capitalization? "abc" would match itself, "Abc", and "ABC"; case sensitive would only match "abc". NOTE: This applies to regex searching as well.                                                                                                                                | `text.chatpatches.search.caseSensitive`   |
| Formatting                    | `false`          | Should the search query allow matching text according to formatting modifiers? "abc" would match "abc" and "§e§labc§r"; with modifiers it would only match "abc" and not "§e§labc§r". NOTE: Hex colors can be matched in the format "&#RRGGBB", however this is in beta.                                                               | `text.chatpatches.search.formatting`      |
| Regex                         | `false`          | Should the search query be used as a regular expression? To learn how to use regex, see the help section in the config. NOTE: Java regex requires a full match, so remember to put "^.*" in front and ".*$" at the end.                                                                                                                | `text.chatpatches.search.regex`           |

## Incompatibilities

- Meteor Client's BetterChat features

## Changelog

The `changelog.md` file has changelog information starting from `194.4.0`.
For individual releases prior to `194.4.0`, check the `latest_changelog.md` file. Check the [GitHub commit list](https://github.com/mrbuilder1961/ChatPatches/commits) for specific, developer-grain details by commit.

## License
This mod is available under the GNU LGPLv3 license. Check out [this](https://choosealicense.com/licenses/lgpl-3.0/) page for information.

## Help

### How to upload log files
There are multiple different types of log file that can be uploaded, although they are all very similar. In order of most useful to least, these are the three
main types:
1. `debug.log` - Generated when the game is configured to output on the `DEBUG` level. It isn't always present, but when it is, it almost always has a ton of
   extra information that can be critical to solving issues. This is a more detailed subset of the `latest.log`.
2. `crash-report-<date>-<time>.txt` - Generated when the game crashes; contains a lot of extra information not provided in the other two logs, however it is
   most useful when coupled with one of the other two logs.
3. `latest.log` - The main log file that is generated every time the game is run. It constantly updates, and contains plenty of useful information on what
   the game is doing.

Generally, you should upload one `.log` file and one `crash-report-<date>-<time>.txt` file if you have them. Otherwise, just upload whatever you have that
is listed above. The only thing you shouldn't upload is both `debug.log` and `latest.log`, as the `debug.log` has everything the `latest.log` has and more.
*TL;DR upload as much as you can, but don't upload both the `debug.log` and `latest.log` files.*

Now that you have the files, simply submitting them to https://mclo.gs/ will give you a link that you can share with me and others to help diagnose your issue.
It is really the only site I use, because it provides a lot of useful tools both for me and for you. One of those being that it censors many instances of
potentially identifiable information, such as your computer's username and IP address.

#### To upload the log(s) without Prism Launcher:
1. Go to https://mclo.gs/
2. Click the "Select a file" button, and select a file. **OR** Paste the contents of the log file into the text box.
3. Click the "Save" button.
4. Wait for a moment, and it will redirect you to your uploaded log file. Copy the URL from the address bar and paste it wherever you were asked or need to
   share it.

#### With Prism Launcher:
1. Open Prism Launcher.
2. Click on your instance that contains the log you want to upload.
3. Navigate to the "Minecraft Log" tab (or "Other logs" tab if it's not there)
4. Click the "Upload" button when the log you want to upload is shown.
5. Click the "Yes" button in response to the security prompt. If you're worried about the security of the log, you can always censor it yourself before
   uploading it.
6. The log should now be uploaded, and you can click the blue underlined text to view it in your browser. The URL is automatically copied to your clipboard,
   so you can now share it wherever you were asked or need to.

### How to access beta releases
To access beta releases, you'll need a link that looks like this:

https://github.com/mrbuilder1961/ChatPatches/actions/runs/8310511511/ or

https://github.com/mrbuilder1961/ChatPatches/actions/runs/8310511511/artifacts/1332245802

#### Now, follow these steps:
1. Click on the link. If it doesn't instantly download, scroll down, and under the "Artifacts" section, click on "jars" and the download should start.
2. Once the download is complete, open or extract the .zip file.
3. You should see two folders, `libs` and `devlibs`. Open the `libs` folder.
4. Inside the `libs` folder, you should see a .jar file, and another file with the same name but instead ends with `-sources.jar`. The .jar file is the mod itself, and the `-sources.jar` file is the source code.
5. Move the .jar file, NOT the `-sources` file, to your mods folder.
6. If you have another version of Chat Patches already installed there, you can move it, rename the file extension to anything but `.jar`, or delete it.
7. Now you should be good to go! Launching the game should now load the beta version. If you experience any issues, make sure to report them as soon as
   possible wherever you were given the link (here on GitHub or [the Discord](https://discord.gg/3MqBvNEyMz)).

### How to find mod(s) causing compatibility issues (binary search)
*(taken from the Fabric Discord bot, not claiming ownership, just sharing knowledge!)*

> A binary search can be used to quickly find a specific mod causing trouble, which can be especially useful when logs don't give a conclusive answer to your issue.

> Start by removing or disabling half of your mods, then test if the problem still occurs. If it does, remove half of the remaining mods and test again. If it doesn't, add back half of the mods you just removed.

> Keep in mind you don't have to stick strictly to halves each time, and may have to enable some library mods like Fabric API out of order.

> By repeating this on an increasingly smaller set of mods, you'll find the problematic mod within a few iterations.

Make sure you leave Chat Patches and it's dependencies installed when you're looking for the problematic mod, otherwise it won't do anything to help diagnose the issue.

## Sponsor me!
- Ko-Fi: https://ko-fi.com/obro1961

[![15% off your first month with code OBRO15!](https://i.imgur.com/9mjs77B.png)](https://billing.kinetichosting.net/aff.php?aff=234)

### (not sponsored; highly encouraged)
[![Use your voice, help the families of Gaza](https://github.com/user-attachments/assets/111407d3-0018-4ac9-b9db-2e515e2e54a0)
](https://linktr.ee/opolivebranch)