package com.techteam.fabric.bettermod.impl.block.entity;

import com.techteam.fabric.bettermod.impl.BetterMod;
import com.techteam.fabric.bettermod.impl.util.InventoryUtil;
import com.techteam.fabric.bettermod.impl.util.Texts;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class StickHopperBlockEntity extends BetterExtractingHopperBlockEntity<StickHopperBlockEntity> {
	public static final class_2960 ID = class_2960.method_60655("bettermod", "stick_hopper");

	public StickHopperBlockEntity(@NotNull class_2338 blockPos, class_2680 blockState) {
		super(BetterMod.STICK_HOPPER_BLOCK_ENTITY_TYPE, blockPos, blockState);
	}

	@Override
	public boolean extract() {
		Storage<ItemVariant> PULL_TARGET = PULL_TARGET_CACHE.find(class_2350.field_11033);
		if (PULL_TARGET != null) {
			return InventoryUtil.handleTransferStackable(PULL_TARGET, SELF);
		}
		return false;
	}

	@Override
	public boolean insert() {
		if (!insertionPos.equals(PUSH_TARGET_CACHE.getPos())) {
			PUSH_TARGET_CACHE = BlockApiCache.create(ItemStorage.SIDED, (class_3218) field_11863, insertionPos);
		}
		Storage<ItemVariant> PUSH_TARGET = PUSH_TARGET_CACHE.find(facing.method_10153());
		if (PUSH_TARGET != null) {
			boolean PUSH_TARGET_EMPTY = !PUSH_TARGET.nonEmptyIterator().hasNext();
			boolean result = InventoryUtil.handleTransferSticky(SELF, PUSH_TARGET);
			if (result) {
				if (PUSH_TARGET_EMPTY && PUSH_TARGET_CACHE.getBlockEntity() instanceof BetterExtractingHopperBlockEntity<?> destinationHopperBlockEntity) {
					if (destinationHopperBlockEntity.LAST_TICK >= this.LAST_TICK) {
						destinationHopperBlockEntity.setCooldown(MAX_COOLDOWN - 1, true);
					} else {
						destinationHopperBlockEntity.setCooldown(MAX_COOLDOWN, false);
					}
				}
			}
			return result;
		}
		return false;
	}

	@Override
	public boolean method_5437(int slot, class_1799 stack) {
		if (stack.method_7914() <= 1) {
			return false;
		}
		return super.method_5437(slot, stack);
	}

	@Override
	public class_2561 method_17823() {
		return Texts.STICK_HOPPER;
	}
}
