package com.techteam.fabric.bettermod;

import com.techteam.fabric.bettermod.impl.BetterMod;
import com.techteam.fabric.bettermod.impl.util.ItemTagKeys;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_141;
import net.minecraft.class_1802;
import net.minecraft.class_2446;
import net.minecraft.class_3489;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import java.util.concurrent.CompletableFuture;

public class BetterModDataGenerator implements DataGeneratorEntrypoint {

	@Override
	public void onInitializeDataGenerator(FabricDataGenerator generator) {
		FabricDataGenerator.Pack pack = generator.createPack();
		pack.addProvider(TagGenerator::new);
		pack.addProvider(LootTableGenerator::new);
		pack.addProvider(BetterModRecipeGenerator::new);
	}

	private static class TagGenerator extends FabricTagProvider.ItemTagProvider {
		public TagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
			super(output, registriesFuture);
		}

		@Override
		protected void method_10514(class_7225.class_7874 arg) {
			valueLookupBuilder(ItemTagKeys.SHELVABLE)
					.forceAddTag(class_3489.field_40109)
					.method_71554(class_1802.field_8407)
					.method_71554(class_1802.field_8204)
					.method_71554(class_1802.field_8895);
		}
	}

	private static class LootTableGenerator extends FabricBlockLootTableProvider {
		protected LootTableGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture) {
			super(dataOutput, registriesFuture);
		}

		@Override
		public void method_10379() {
			method_46025(BetterMod.BIT_HOPPER_BLOCK);
			method_46025(BetterMod.PULL_HOPPER_BLOCK);
			method_46025(BetterMod.STICK_HOPPER_BLOCK);
			method_45988(BetterMod.ROOM_CONTROLLER_BLOCK, class_52.method_324().method_336(
					class_55.method_347().method_351(
							class_77.method_411(class_1802.field_8695)
									 .method_438(class_141.method_621(new class_44(4))))
			).method_336(
					class_55.method_347().method_351(
							class_77.method_411(class_1802.field_8725)
									 .method_438(class_141.method_621(new class_44(4))))
			).method_336(
					class_55.method_347().method_351(
							class_77.method_411(class_1802.field_8634))
			));
		}
	}

	private static class BetterModRecipeGenerator extends FabricRecipeProvider {
		public BetterModRecipeGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
			super(output, registriesFuture);
		}

		@Override
		protected class_2446 method_62766(class_7225.class_7874 registryLookup, class_8790 exporter) {
			return new class_2446(registryLookup, exporter) {
				@Override
				public void method_10419() {
					method_62746(class_7800.field_40636, BetterMod.BIT_HOPPER_BLOCK)
							.method_10439("   ")
							.method_10439("ICI")
							.method_10439(" I ")
							.method_10434('I', class_1802.field_8620)
							.method_10434('C', class_1802.field_8106)
							.method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
							.method_10431(field_53721);
					method_62746(class_7800.field_40636, BetterMod.PULL_HOPPER_BLOCK)
							.method_10439("ICI")
							.method_10439("I I")
							.method_10439(" I ")
							.method_10434('I', class_1802.field_8620)
							.method_10434('C', class_1802.field_8106)
							.method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
							.method_10431(field_53721);
					method_62746(class_7800.field_40636, BetterMod.STICK_HOPPER_BLOCK)
							.method_10439("ISI")
							.method_10439("ICI")
							.method_10439("SIS")
							.method_10434('I', class_1802.field_8620)
							.method_10434('C', class_1802.field_8106)
							.method_10434('S', class_1802.field_8777)
							.method_10429(method_32807(class_1802.field_8777), method_10426(class_1802.field_8777))
							.method_10431(field_53721);
				}
			};
		}

		@Override
		public String method_10321() {
			return "BetterMod";
		}
	}
}