package com.techteam.fabric.bettermod.impl.block;

import com.techteam.fabric.bettermod.api.block.BetterTickingBlock;
import com.techteam.fabric.bettermod.impl.block.entity.BetterHopperBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public abstract class BetterHopperBlock<T extends BetterHopperBlockEntity<T>> extends BetterTickingBlock<T> {
	public BetterHopperBlock(class_2251 settings) {
		super(settings);
	}

	@Override
	protected boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
		return false;
	}

	@Nullable
	@Override
	public class_2680 method_9605(class_1750 ctx) {
		class_2350 direction = ctx.method_8038().method_10153();
		return this.method_9564().method_11657(
				class_2377.field_11129,
				direction.method_10166() == class_2350.class_2351.field_11052
				? class_2350.field_11033
				: direction
		);
	}

	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(class_2377.field_11129);
	}

	@Override
	protected boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	protected int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
		return StorageUtil.calculateComparatorOutput(ItemStorage.SIDED.find(world, pos, direction));
	}

	@Override
	protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
		// Present for Lithium compatibility.
		return super.method_9559(
				state,
				world,
				tickView,
				pos,
				direction,
				neighborPos,
				neighborState,
				random
		);
	}

	@Override
	protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
		// Present for Lithium compatibility.
		super.method_9612(state, world, pos, sourceBlock, wireOrientation, notify);
	}
}
