package com.techteam.fabric.bettermod.impl.mixin.lithium;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.techteam.fabric.bettermod.impl.block.entity.BetterExtractingHopperBlockEntity;
import net.caffeinemc.mods.lithium.api.inventory.LithiumInventory;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_comparator_tracking.ComparatorTracker;
import net.caffeinemc.mods.lithium.common.hopper.*;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;
import java.util.function.BooleanSupplier;

@Mixin(value = BetterExtractingHopperBlockEntity.class)
public abstract class BetterExtractingHopperBlockEntityMixin<T extends BetterExtractingHopperBlockEntity<T>> extends BetterHopperBlockEntityMixin<T> {
	@Unique
	@NotNull
	private HopperCachingState.BlockInventory extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
	@Unique
	private long extractStackListModCount;
	@Unique
	private long myModCountAtLastExtract;

	@Unique
	private @Nullable class_1263 extractBlockInventory;
	@Unique
	private @Nullable LithiumInventory extractInventory;
	@Unique
	private @Nullable LithiumStackList extractStackList;

	@SuppressWarnings("unused")
	public BetterExtractingHopperBlockEntityMixin(class_2591<T> blockEntityType, @NotNull class_2338 blockPos, class_2680 blockState, int size) {
		super(blockEntityType, blockPos, blockState, size);
	}

	@WrapMethod(method = "extract",
				remap = false)
	public boolean extractHook(Operation<Boolean> fallback) {
		var extractInventory = getExtractBlockInventory(field_11863);
		return lithiumExtract(extractInventory, fallback::call);
	}

	@Inject(method = "scheduledTick",
			at = @At("RETURN"))
	public void scheduledTickHook(class_1937 world, class_2338 pos, class_2680 blockState, CallbackInfo callbackInfo) {
		this.checkSleepingConditions();
	}


	public void lithium$invalidateCacheOnNeighborUpdate(boolean fromAbove) {
		if (fromAbove) {
			if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
				this.invalidateBlockExtractionData();
			}
		} else if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
			this.invalidateBlockInsertionData();
		}
	}

	public void lithium$invalidateCacheOnUndirectedNeighborUpdate() {
		if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
			this.invalidateBlockExtractionData();
		}
		if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
			this.invalidateBlockInsertionData();
		}
	}

	public void lithium$invalidateCacheOnNeighborUpdate(class_2350 fromDirection) {
		boolean fromAbove = fromDirection == class_2350.field_11036;
		if (fromAbove || this.method_11010().method_11654(class_2377.field_11129) == fromDirection) {
			this.lithium$invalidateCacheOnNeighborUpdate(fromAbove);
		}

	}

	@Unique
	private class_1263 getExtractBlockInventory(class_1937 world) {
		class_1263 blockInventory = this.extractBlockInventory;
		switch (this.extractionMode) {
			case NO_BLOCK_INVENTORY -> {
				return null;
			}
			case BLOCK_STATE, REMOVAL_TRACKING_BLOCK_ENTITY -> {
				return blockInventory;
			}
			default -> {
				class_2338 pos;
				if (this.extractionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY) {
					class_2586 blockEntity = (class_2586) Objects.requireNonNull(blockInventory);
					pos = blockEntity.method_11016();
					class_2338 transferPos = this.method_11016().method_10084();
					if (!blockEntity.method_11015() && pos.equals(transferPos)) {
						LithiumInventory optimizedInventory;
						if ((optimizedInventory = this.extractInventory) == null) {
							return blockInventory;
						}

						LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(
								optimizedInventory);
						if (insertInventoryStackList == this.extractStackList) {
							return optimizedInventory;
						}

						this.invalidateBlockExtractionData();
					}
				}
				pos = this.method_11016().method_10084();
				class_2680 blockState = world.method_8320(pos);
				blockInventory = HopperBlockEntityInvoker.invokeGetBlockInventoryAt(world, pos, blockState);
				blockInventory = HopperHelper.replaceDoubleInventory(blockInventory);
				this.cacheExtractBlockInventory(blockInventory);
				return blockInventory;
			}
		}
	}

	@Unique
	private void cacheExtractBlockInventory(class_1263 extractInventory) {
		assert !(extractInventory instanceof class_1297);

		if (extractInventory instanceof LithiumInventory optimizedInventory) {
			this.cacheExtractLithiumInventory(optimizedInventory);
		} else {
			this.extractInventory = null;
			this.extractStackList = null;
			this.extractStackListModCount = 0L;
		}

		if (!(extractInventory instanceof class_2586) && !(extractInventory instanceof class_1258)) {
			if (extractInventory == null) {
				this.extractBlockInventory = null;
				this.extractionMode = HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY;
			} else {
				this.extractBlockInventory = extractInventory;
				this.extractionMode = extractInventory instanceof BlockStateOnlyInventory
									  ? HopperCachingState.BlockInventory.BLOCK_STATE
									  : HopperCachingState.BlockInventory.UNKNOWN;
			}
		} else {
			this.extractBlockInventory = extractInventory;
			if (extractInventory instanceof InventoryChangeTracker) {
				this.extractionMode = HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY;
				((InventoryChangeTracker) extractInventory).listenForMajorInventoryChanges(this);
			} else {
				this.extractionMode = HopperCachingState.BlockInventory.BLOCK_ENTITY;
			}
		}

	}

	public void lithium$handleInventoryRemoved(class_1263 inventory) {
		this.wakeUpNow();

		if (inventory == this.insertBlockInventory) {
			this.invalidateBlockInsertionData();
		}

		if (inventory == this.extractBlockInventory) {
			this.invalidateBlockExtractionData();
		}

		if (inventory == this) {
			this.invalidateCachedData();
		}
	}

	@Unique
	private void invalidateCachedData() {
		this.shouldCheckSleep = false;
		this.invalidateInsertionData();
		this.invalidateExtractionData();
	}

	@Unique
	private void invalidateExtractionData() {
		if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
			assert this.extractBlockInventory != null;

			((InventoryChangeTracker) this.extractBlockInventory).stopListenForMajorInventoryChanges(this);
		}

		this.invalidateBlockExtractionData();
	}

	@Unique
	private void invalidateBlockExtractionData() {
		this.extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
		this.extractBlockInventory = null;
		this.extractInventory = null;
		this.extractStackList = null;
		this.extractStackListModCount = 0L;
		this.wakeUpNow();
	}

	@Unique
	private void cacheExtractLithiumInventory(LithiumInventory optimizedInventory) {
		LithiumStackList extractInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
		this.extractInventory = optimizedInventory;
		this.extractStackList = extractInventoryStackList;
		this.extractStackListModCount = extractInventoryStackList.getModCount() - 1L;
	}

	@Unique
	private void checkSleepingConditions() {
		if (!(this.cooldown > 0)) {
			if (this.isSleeping()) {
				return;
			}

			if (!this.shouldCheckSleep) {
				this.shouldCheckSleep = true;
				return;
			}

			boolean listenToExtractTracker = false;
			boolean listenToInsertTracker = false;
			LithiumStackList thisStackList = InventoryHelper.getLithiumStackList(this);
			class_1263 blockInventory;
			if (this.extractionMode != HopperCachingState.BlockInventory.BLOCK_STATE && thisStackList.getFullSlots() != thisStackList.size()) {
				if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
					blockInventory = this.extractBlockInventory;
					if (this.extractStackList != null && blockInventory instanceof InventoryChangeTracker) {
						if (!this.extractStackList.maybeSendsComparatorUpdatesOnFailedExtract() || (blockInventory instanceof ComparatorTracker comparatorTracker && !comparatorTracker.lithium$hasAnyComparatorNearby())) {
							listenToExtractTracker = true;
						} else {
							return;
						}
					} else {
						return;
					}
				} else {
					if (this.extractionMode != HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) {
						return;
					}
				}
			}

			if (this.insertionMode != HopperCachingState.BlockInventory.BLOCK_STATE && 0 < thisStackList.getOccupiedSlots()) {
				if (this.insertionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
					blockInventory = this.insertBlockInventory;
					if (this.insertStackList == null || !(blockInventory instanceof InventoryChangeTracker)) {
						return;
					}

					listenToInsertTracker = true;
				} else {
					if (this.insertionMode != HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) {
						return;
					}
				}
			}

			if (listenToExtractTracker) {
				((InventoryChangeTracker) this.extractBlockInventory).listenForContentChangesOnce(
						this.extractStackList,
						this
				);
			}

			if (listenToInsertTracker) {
				((InventoryChangeTracker) this.insertBlockInventory).listenForContentChangesOnce(
						this.insertStackList,
						this
				);
			}

			this.listenForContentChangesOnce(thisStackList, this);
			this.lithium$startSleeping();
		}
	}

	public boolean lithium$handleComparatorAdded(class_1263 inventory) {
		if (inventory == this.extractBlockInventory) {
			this.wakeUpNow();
			return true;
		} else {
			return false;
		}
	}

	@Unique
	private boolean lithiumExtract(class_1263 from, BooleanSupplier fallback) {
		if (from != this.extractInventory || this.extractStackList == null) {
			return fallback.getAsBoolean(); //from inventory is not an optimized inventory, vanilla fallback
		}

		LithiumStackList hopperStackList = InventoryHelper.getLithiumStackList(this);
		LithiumStackList fromStackList = this.extractStackList;

		if (hopperStackList.getModCount() == this.myModCountAtLastExtract) {
			if (fromStackList.getModCount() == this.extractStackListModCount) {
				if (!(from instanceof ComparatorTracker comparatorTracker) || comparatorTracker.lithium$hasAnyComparatorNearby()) {
					//noinspection CollectionAddedToSelf
					fromStackList.runComparatorUpdatePatternOnFailedExtract(fromStackList, from);
				}
				return false;
			}
		}

		int[] availableSlots = from instanceof class_1278 sidedInventory
							   ? sidedInventory.method_5494(class_2350.field_11033)
							   : null;
		int fromSize = availableSlots != null
					   ? availableSlots.length
					   : from.method_5439();
		for (int i = 0; i < fromSize; i++) {
			int fromSlot = availableSlots != null
						   ? availableSlots[i]
						   : i;
			class_1799 itemStack = fromStackList.get(fromSlot);
			if (!itemStack.method_7960() && HopperBlockEntityInvoker.invokeCanExtract(
					this,
					from,
					itemStack,
					fromSlot,
					class_2350.field_11033
			)) {
				//calling removeStack is necessary due to its side effects (markDirty in LootableContainerBlockEntity)
				class_1799 takenItem = from.method_5434(fromSlot, 1);
				assert !takenItem.method_7960();
				boolean transferSuccess = HopperHelper.tryMoveSingleItem(this, takenItem, null);
				if (transferSuccess) {
					this.method_5431();
					from.method_5431();
					return true;
				}
				//put the item back similar to vanilla
				class_1799 restoredStack = fromStackList.get(fromSlot);
				if (restoredStack.method_7960()) {
					restoredStack = takenItem;
				} else {
					restoredStack.method_7933(1);
				}
				//calling setStack is necessary due to its side effects (markDirty in LootableContainerBlockEntity)
				from.method_5447(fromSlot, restoredStack);
			}
		}
		this.myModCountAtLastExtract = hopperStackList.getModCount();
		if (fromStackList != null) {
			this.extractStackListModCount = fromStackList.getModCount();
		}
		return false;
	}
}
