package com.techteam.fabric.bettermod.api.block.entity;

import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;

public abstract class BetterBlockEntity extends class_2621 implements SidedStorageBlockEntity {
	protected class_2371<class_1799> inventory;
	public final SlottedStorage<ItemVariant> SELF;
	protected final int size;

	// Unused for most.
	private UUID uuid = UUID.randomUUID();

	public BetterBlockEntity(class_2591<?> blockEntityType, @NotNull class_2338 blockPos, class_2680 blockState, int size) {
		super(blockEntityType, blockPos, blockState);
		this.size = size;
		this.inventory = class_2371.method_10213(size, class_1799.field_8037);
		this.SELF = InventoryStorage.of(BetterBlockEntity.this, null);
	}

	@Contract(pure = true)
	public final UUID getUUID() {
		return uuid;
	}

	@Override
	protected void method_11014(class_11368 view) {
		super.method_11014(view);
		view.method_71426(class_1297.field_29994, class_4844.field_25122).ifPresent(uuid -> this.uuid = uuid);
		this.inventory = class_2371.method_10213(this.method_5439(), class_1799.field_8037);
		if (!this.method_54871(view)) {
			class_1262.method_5429(view, this.inventory);
		}
	}

	@Override
	public void method_11007(class_11372 view) {
		super.method_11007(view);
		view.method_71468(class_1297.field_29994, class_4844.field_25122, this.getUUID());
		if (!this.method_54872(view)) {
			class_1262.method_5426(view, this.inventory);
		}
	}

	@Override
	protected class_2371<class_1799> method_11282() {
		return this.inventory;
	}

	@Override
	protected void method_11281(class_2371<class_1799> inventory) {
		this.inventory = inventory;
	}

	@Override
	public int method_5439() {
		return size;
	}

	@Override
	public @Nullable Storage<ItemVariant> getItemStorage(@Nullable class_2350 side) {
		return SELF;
	}
}
