package com.techteam.fabric.bettermod.impl.block.entity;

import com.techteam.fabric.bettermod.api.block.entity.TickOnInterval;
import com.techteam.fabric.bettermod.impl.util.InventoryUtil;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1722;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public abstract class BetterHopperBlockEntity<T extends BetterHopperBlockEntity<T>> extends TickOnInterval<T> {
	public static final int MAX_COOLDOWN = 8;
	protected class_2338 insertionPos;
	protected class_2350 facing;
	protected BlockApiCache<Storage<ItemVariant>, class_2350> PUSH_TARGET_CACHE;

	public BetterHopperBlockEntity(class_2591<T> blockEntityType, @NotNull class_2338 blockPos, class_2680 blockState) {
		super(blockEntityType, blockPos, blockState, 5);
		facing = blockState.method_11654(class_2741.field_12545);
		insertionPos = field_11867.method_10093(facing);
	}

	@Override
	public class_1703 method_5465(int syncId, class_1661 playerInventory) {
		return new class_1722(syncId, playerInventory, this);
	}

	@Override
	@SuppressWarnings("deprecation")
	public void method_31664(class_2680 state) {
		facing = state.method_11654(class_2741.field_12545);
		insertionPos = field_11867.method_10093(facing);
		super.method_31664(state);
	}

	@Override
	public void method_31662(class_1937 world) {
		super.method_31662(world);
		if (world instanceof class_3218 serverWorld) {
			PUSH_TARGET_CACHE = BlockApiCache.create(ItemStorage.SIDED, serverWorld, insertionPos);
		}
	}

	public boolean insert() {
		if (!insertionPos.equals(PUSH_TARGET_CACHE.getPos())) {
			PUSH_TARGET_CACHE = BlockApiCache.create(ItemStorage.SIDED, (class_3218) field_11863, insertionPos);
		}
		Storage<ItemVariant> PUSH_TARGET = PUSH_TARGET_CACHE.find(facing.method_10153());
		if (PUSH_TARGET != null) {
			boolean PUSH_TARGET_EMPTY = !PUSH_TARGET.nonEmptyIterator().hasNext();
			boolean result = InventoryUtil.handleTransfer(SELF, PUSH_TARGET);
			if (result) {
				if (PUSH_TARGET_EMPTY && PUSH_TARGET_CACHE.getBlockEntity() instanceof BetterExtractingHopperBlockEntity<?> extractingHopperBlockEntity) {
					if (extractingHopperBlockEntity.LAST_TICK >= this.LAST_TICK) {
						extractingHopperBlockEntity.setCooldown(MAX_COOLDOWN - 1, true);
					} else {
						extractingHopperBlockEntity.setCooldown(MAX_COOLDOWN, false);
					}
				}
			}
			return result;
		}
		return false;
	}

	@Override
	public void scheduledTick(class_1937 world, class_2338 pos, class_2680 blockState) {
		boolean activated = false;
		// Push
		if (!method_5442()) {
			activated = this.insert();
		}
		if (activated) {
			setCooldown(BetterHopperBlockEntity.MAX_COOLDOWN, false);
		}
	}
}
