/*
 * Decompiled with CFR 0.152.
 */
package com.techteam.fabric.bettermod.impl.mixin.lithium;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.techteam.fabric.bettermod.impl.block.entity.BetterExtractingHopperBlockEntity;
import com.techteam.fabric.bettermod.impl.mixin.lithium.BetterHopperBlockEntityMixin;
import com.techteam.fabric.bettermod.impl.mixin.lithium.HopperBlockEntityInvoker;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.caffeinemc.mods.lithium.api.inventory.LithiumInventory;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeListener;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_comparator_tracking.ComparatorTracker;
import net.caffeinemc.mods.lithium.common.hopper.BlockStateOnlyInventory;
import net.caffeinemc.mods.lithium.common.hopper.HopperCachingState;
import net.caffeinemc.mods.lithium.common.hopper.HopperHelper;
import net.caffeinemc.mods.lithium.common.hopper.InventoryHelper;
import net.caffeinemc.mods.lithium.common.hopper.LithiumStackList;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BetterExtractingHopperBlockEntity.class})
public abstract class BetterExtractingHopperBlockEntityMixin<T extends BetterExtractingHopperBlockEntity<T>>
extends BetterHopperBlockEntityMixin<T> {
    @Unique
    @NotNull
    private HopperCachingState.BlockInventory extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
    @Unique
    private long extractStackListModCount;
    @Unique
    private long myModCountAtLastExtract;
    @Unique
    @Nullable
    private class_1263 extractBlockInventory;
    @Unique
    @Nullable
    private LithiumInventory extractInventory;
    @Unique
    @Nullable
    private LithiumStackList extractStackList;

    public BetterExtractingHopperBlockEntityMixin(class_2591<T> blockEntityType, @NotNull class_2338 blockPos, class_2680 blockState, int size) {
        super(blockEntityType, blockPos, blockState, size);
    }

    @WrapMethod(method={"extract"}, remap=false)
    public boolean extractHook(Operation<Boolean> fallback) {
        class_1263 extractInventory = this.getExtractBlockInventory(this.field_11863);
        return this.lithiumExtract(extractInventory, () -> (Boolean)fallback.call(new Object[0]));
    }

    @Inject(method={"scheduledTick"}, at={@At(value="RETURN")})
    public void scheduledTickHook(class_1937 world, class_2338 pos, class_2680 blockState, CallbackInfo callbackInfo) {
        this.checkSleepingConditions();
    }

    @Override
    public void lithium$invalidateCacheOnNeighborUpdate(boolean fromAbove) {
        if (fromAbove) {
            if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
                this.invalidateBlockExtractionData();
            }
        } else if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            this.invalidateBlockInsertionData();
        }
    }

    @Override
    public void lithium$invalidateCacheOnUndirectedNeighborUpdate() {
        if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            this.invalidateBlockExtractionData();
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            this.invalidateBlockInsertionData();
        }
    }

    @Override
    public void lithium$invalidateCacheOnNeighborUpdate(class_2350 fromDirection) {
        boolean fromAbove;
        boolean bl = fromAbove = fromDirection == class_2350.field_11036;
        if (fromAbove || this.method_11010().method_11654((class_2769)class_2377.field_11129) == fromDirection) {
            this.lithium$invalidateCacheOnNeighborUpdate(fromAbove);
        }
    }

    @Unique
    private class_1263 getExtractBlockInventory(class_1937 world) {
        class_2338 pos;
        class_1263 blockInventory = this.extractBlockInventory;
        switch (this.extractionMode) {
            case NO_BLOCK_INVENTORY: {
                return null;
            }
            case BLOCK_STATE: 
            case REMOVAL_TRACKING_BLOCK_ENTITY: {
                return blockInventory;
            }
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY) {
            class_2586 blockEntity = (class_2586)Objects.requireNonNull(blockInventory);
            pos = blockEntity.method_11016();
            class_2338 transferPos = this.method_11016().method_10084();
            if (!blockEntity.method_11015() && pos.equals((Object)transferPos)) {
                LithiumInventory optimizedInventory = this.extractInventory;
                if (optimizedInventory == null) {
                    return blockInventory;
                }
                LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList((LithiumInventory)optimizedInventory);
                if (insertInventoryStackList == this.extractStackList) {
                    return optimizedInventory;
                }
                this.invalidateBlockExtractionData();
            }
        }
        pos = this.method_11016().method_10084();
        class_2680 blockState = world.method_8320(pos);
        blockInventory = HopperBlockEntityInvoker.invokeGetBlockInventoryAt(world, pos, blockState);
        blockInventory = HopperHelper.replaceDoubleInventory((class_1263)blockInventory);
        this.cacheExtractBlockInventory(blockInventory);
        return blockInventory;
    }

    @Unique
    private void cacheExtractBlockInventory(class_1263 extractInventory) {
        assert (!(extractInventory instanceof class_1297));
        if (extractInventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)extractInventory;
            this.cacheExtractLithiumInventory(optimizedInventory);
        } else {
            this.extractInventory = null;
            this.extractStackList = null;
            this.extractStackListModCount = 0L;
        }
        if (!(extractInventory instanceof class_2586) && !(extractInventory instanceof class_1258)) {
            if (extractInventory == null) {
                this.extractBlockInventory = null;
                this.extractionMode = HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY;
            } else {
                this.extractBlockInventory = extractInventory;
                this.extractionMode = extractInventory instanceof BlockStateOnlyInventory ? HopperCachingState.BlockInventory.BLOCK_STATE : HopperCachingState.BlockInventory.UNKNOWN;
            }
        } else {
            this.extractBlockInventory = extractInventory;
            if (extractInventory instanceof InventoryChangeTracker) {
                this.extractionMode = HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY;
                ((InventoryChangeTracker)extractInventory).listenForMajorInventoryChanges((InventoryChangeListener)this);
            } else {
                this.extractionMode = HopperCachingState.BlockInventory.BLOCK_ENTITY;
            }
        }
    }

    @Override
    public void lithium$handleInventoryRemoved(class_1263 inventory) {
        this.wakeUpNow();
        if (inventory == this.insertBlockInventory) {
            this.invalidateBlockInsertionData();
        }
        if (inventory == this.extractBlockInventory) {
            this.invalidateBlockExtractionData();
        }
        if (inventory == this) {
            this.invalidateCachedData();
        }
    }

    @Unique
    private void invalidateCachedData() {
        this.shouldCheckSleep = false;
        this.invalidateInsertionData();
        this.invalidateExtractionData();
    }

    @Unique
    private void invalidateExtractionData() {
        if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
            assert (this.extractBlockInventory != null);
            ((InventoryChangeTracker)this.extractBlockInventory).stopListenForMajorInventoryChanges((InventoryChangeListener)this);
        }
        this.invalidateBlockExtractionData();
    }

    @Unique
    private void invalidateBlockExtractionData() {
        this.extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
        this.extractBlockInventory = null;
        this.extractInventory = null;
        this.extractStackList = null;
        this.extractStackListModCount = 0L;
        this.wakeUpNow();
    }

    @Unique
    private void cacheExtractLithiumInventory(LithiumInventory optimizedInventory) {
        LithiumStackList extractInventoryStackList = InventoryHelper.getLithiumStackList((LithiumInventory)optimizedInventory);
        this.extractInventory = optimizedInventory;
        this.extractStackList = extractInventoryStackList;
        this.extractStackListModCount = extractInventoryStackList.getModCount() - 1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Unique
    private void checkSleepingConditions() {
        class_1263 blockInventory;
        if (this.cooldown > 0) return;
        if (this.isSleeping()) {
            return;
        }
        if (!this.shouldCheckSleep) {
            this.shouldCheckSleep = true;
            return;
        }
        boolean listenToExtractTracker = false;
        boolean listenToInsertTracker = false;
        LithiumStackList thisStackList = InventoryHelper.getLithiumStackList((LithiumInventory)this);
        if (this.extractionMode != HopperCachingState.BlockInventory.BLOCK_STATE && thisStackList.getFullSlots() != thisStackList.size()) {
            if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
                ComparatorTracker comparatorTracker;
                blockInventory = this.extractBlockInventory;
                if (this.extractStackList == null || !(blockInventory instanceof InventoryChangeTracker)) return;
                if (this.extractStackList.maybeSendsComparatorUpdatesOnFailedExtract() && (!(blockInventory instanceof ComparatorTracker) || (comparatorTracker = (ComparatorTracker)blockInventory).lithium$hasAnyComparatorNearby())) return;
                listenToExtractTracker = true;
            } else if (this.extractionMode != HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) {
                return;
            }
        }
        if (this.insertionMode != HopperCachingState.BlockInventory.BLOCK_STATE && 0 < thisStackList.getOccupiedSlots()) {
            if (this.insertionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
                blockInventory = this.insertBlockInventory;
                if (this.insertStackList == null || !(blockInventory instanceof InventoryChangeTracker)) {
                    return;
                }
                listenToInsertTracker = true;
            } else if (this.insertionMode != HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) {
                return;
            }
        }
        if (listenToExtractTracker) {
            ((InventoryChangeTracker)this.extractBlockInventory).listenForContentChangesOnce(this.extractStackList, (InventoryChangeListener)this);
        }
        if (listenToInsertTracker) {
            ((InventoryChangeTracker)this.insertBlockInventory).listenForContentChangesOnce(this.insertStackList, (InventoryChangeListener)this);
        }
        this.listenForContentChangesOnce(thisStackList, this);
        this.lithium$startSleeping();
    }

    @Override
    public boolean lithium$handleComparatorAdded(class_1263 inventory) {
        if (inventory == this.extractBlockInventory) {
            this.wakeUpNow();
            return true;
        }
        return false;
    }

    @Unique
    private boolean lithiumExtract(class_1263 from, BooleanSupplier fallback) {
        int[] nArray;
        if (from != this.extractInventory || this.extractStackList == null) {
            return fallback.getAsBoolean();
        }
        LithiumStackList hopperStackList = InventoryHelper.getLithiumStackList((LithiumInventory)this);
        LithiumStackList fromStackList = this.extractStackList;
        if (hopperStackList.getModCount() == this.myModCountAtLastExtract && fromStackList.getModCount() == this.extractStackListModCount) {
            ComparatorTracker comparatorTracker;
            if (!(from instanceof ComparatorTracker) || (comparatorTracker = (ComparatorTracker)from).lithium$hasAnyComparatorNearby()) {
                fromStackList.runComparatorUpdatePatternOnFailedExtract(fromStackList, from);
            }
            return false;
        }
        if (from instanceof class_1278) {
            class_1278 sidedInventory = (class_1278)from;
            nArray = sidedInventory.method_5494(class_2350.field_11033);
        } else {
            nArray = null;
        }
        int[] availableSlots = nArray;
        int fromSize = availableSlots != null ? availableSlots.length : from.method_5439();
        for (int i = 0; i < fromSize; ++i) {
            int fromSlot = availableSlots != null ? availableSlots[i] : i;
            class_1799 itemStack = (class_1799)fromStackList.get(fromSlot);
            if (itemStack.method_7960() || !HopperBlockEntityInvoker.invokeCanExtract((class_1263)this, from, itemStack, fromSlot, class_2350.field_11033)) continue;
            class_1799 takenItem = from.method_5434(fromSlot, 1);
            assert (!takenItem.method_7960());
            boolean transferSuccess = HopperHelper.tryMoveSingleItem((class_1263)this, (class_1799)takenItem, null);
            if (transferSuccess) {
                this.method_5431();
                from.method_5431();
                return true;
            }
            class_1799 restoredStack = (class_1799)fromStackList.get(fromSlot);
            if (restoredStack.method_7960()) {
                restoredStack = takenItem;
            } else {
                restoredStack.method_7933(1);
            }
            from.method_5447(fromSlot, restoredStack);
        }
        this.myModCountAtLastExtract = hopperStackList.getModCount();
        if (fromStackList != null) {
            this.extractStackListModCount = fromStackList.getModCount();
        }
        return false;
    }
}

