/*
 * Decompiled with CFR 0.152.
 */
package com.techteam.fabric.bettermod.impl.util;

import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class InventoryUtil {
    public static boolean handleTransfer(@NotNull Storage<ItemVariant> from, @NotNull Storage<ItemVariant> to) {
        for (StorageView view : from) {
            if (view.isResourceBlank() || !InventoryUtil.handle(to, (StorageView<ItemVariant>)view)) continue;
            return true;
        }
        return false;
    }

    public static boolean handleTransferStackable(@NotNull Storage<ItemVariant> from, @NotNull Storage<ItemVariant> to) {
        for (StorageView view : from) {
            if (view.isResourceBlank() || view.getCapacity() <= 1L || !InventoryUtil.handle(to, (StorageView<ItemVariant>)view)) continue;
            return true;
        }
        return false;
    }

    private static boolean handle(Storage<ItemVariant> to, StorageView<ItemVariant> view) {
        ItemVariant resource = (ItemVariant)view.getResource();
        try (Transaction transferTransaction = Transaction.openOuter();){
            if (to.insert((Object)resource, 1L, (TransactionContext)transferTransaction) == 1L && view.extract((Object)resource, 1L, (TransactionContext)transferTransaction) == 1L) {
                transferTransaction.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

