/*
 * Decompiled with CFR 0.152.
 */
package me.ddkolbb.dreconnect.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class DreconnectConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "dreconnect.json";
    private static int countdownSeconds = 5;

    public static void load() {
        Path configPath = Platform.getConfigFolder().resolve(FILE_NAME);
        if (Files.notExists(configPath, new LinkOption[0])) {
            DreconnectConfig.save();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(configPath, StandardCharsets.UTF_8);){
            JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (obj != null && obj.has("countdownSeconds")) {
                int v = obj.get("countdownSeconds").getAsInt();
                if (v < 0) {
                    v = 0;
                }
                countdownSeconds = v;
            }
        }
        catch (Exception e) {
            System.err.println("[dReconnect] Failed to load config, using defaults: " + e.getMessage());
        }
    }

    public static void save() {
        Path configPath = Platform.getConfigFolder().resolve(FILE_NAME);
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JsonObject obj = new JsonObject();
        obj.addProperty("countdownSeconds", (Number)countdownSeconds);
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((JsonElement)obj, (Appendable)writer);
        }
        catch (Exception e) {
            System.err.println("[dReconnect] Failed to save config: " + e.getMessage());
        }
    }

    public static int getCountdownSeconds() {
        return countdownSeconds;
    }

    public static void setCountdownSeconds(int seconds) {
        countdownSeconds = Math.max(0, seconds);
    }

    private DreconnectConfig() {
    }
}

