/*
 * Decompiled with CFR 0.152.
 */
package me.ddkolbb.dreconnect.client;

import dev.architectury.event.events.client.ClientTickEvent;
import java.util.Objects;
import me.ddkolbb.dreconnect.config.DreconnectConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;

public final class AutoReconnectClient {
    private static boolean enabled = false;
    private static int countdownSeconds = 0;
    private static ServerData lastServerData = null;
    private static int tickCounter = 0;
    private static int lastX;
    private static int lastY;
    private static int lastW;
    private static int lastH;

    public static void init() {
        DreconnectConfig.load();
        ClientTickEvent.CLIENT_POST.register(client -> {
            Screen screen;
            if (client != null && client.m_91089_() != null) {
                lastServerData = client.m_91089_();
            }
            if ((screen = client.f_91080_) instanceof DisconnectedScreen && enabled) {
                if (countdownSeconds == 0 && lastServerData != null) {
                    countdownSeconds = DreconnectConfig.getCountdownSeconds();
                }
                if (countdownSeconds > 0 && ++tickCounter >= 20) {
                    tickCounter = 0;
                    if (--countdownSeconds <= 0) {
                        AutoReconnectClient.tryReconnect();
                    }
                }
            } else {
                tickCounter = 0;
            }
        });
    }

    public static void onScreenOpened(Screen screen) {
        countdownSeconds = screen instanceof DisconnectedScreen ? (enabled && lastServerData != null ? DreconnectConfig.getCountdownSeconds() : 0) : 0;
    }

    public static void onRender(Screen screen, GuiGraphics guiGraphics) {
        if (screen instanceof DisconnectedScreen) {
            AutoReconnectClient.renderToggle(guiGraphics, screen);
        }
    }

    public static boolean onMouseClicked(Screen screen, double mouseX, double mouseY, int button) {
        if (!(screen instanceof DisconnectedScreen)) {
            return false;
        }
        return AutoReconnectClient.handleClick(screen, mouseX, mouseY, button);
    }

    public static boolean onKeyPressed(Screen screen, int keyCode) {
        if (!(screen instanceof DisconnectedScreen)) {
            return false;
        }
        if (keyCode == 82) {
            AutoReconnectClient.toggleEnabled();
            return true;
        }
        return false;
    }

    private static void renderToggle(GuiGraphics graphics, Screen screen) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        int width = screen.f_96543_;
        int height = screen.f_96544_;
        Object text = !enabled ? "AutoReconnect: OFF" : (countdownSeconds > 0 ? "Reconnect in " + countdownSeconds + "..." : "AutoReconnect: ON");
        int color = countdownSeconds > 0 ? 0xFFFFFF : (enabled ? 0xE0E0E0 : 0xB0B0B0);
        int margin = 6;
        int textWidth = mc.f_91062_.m_92895_((String)text);
        int x = Math.max(margin, width - textWidth - margin);
        Objects.requireNonNull(mc.f_91062_);
        int y = Math.max(margin, height - 9 - margin);
        graphics.m_280056_(mc.f_91062_, (String)text, x, y, color, true);
        lastX = x;
        lastY = y;
        lastW = textWidth;
        Objects.requireNonNull(mc.f_91062_);
        lastH = 9;
    }

    private static boolean handleClick(Screen screen, double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        if (mouseX >= (double)(lastX - 3) && mouseX <= (double)(lastX + lastW + 3) && mouseY >= (double)(lastY - 2) && mouseY <= (double)(lastY + lastH + 2)) {
            AutoReconnectClient.toggleEnabled();
            return true;
        }
        return false;
    }

    private static void toggleEnabled() {
        boolean bl = enabled = !enabled;
        if (enabled) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc != null && mc.f_91080_ instanceof DisconnectedScreen && lastServerData != null) {
                countdownSeconds = DreconnectConfig.getCountdownSeconds();
            }
        } else {
            countdownSeconds = 0;
        }
    }

    private static void tryReconnect() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || lastServerData == null) {
            return;
        }
        Screen parent = mc.f_91080_;
        countdownSeconds = 0;
        tickCounter = 0;
        ServerAddress address = ServerAddress.m_171864_((String)AutoReconnectClient.lastServerData.f_105363_);
        mc.execute(() -> ConnectScreen.m_278792_((Screen)parent, (Minecraft)mc, (ServerAddress)address, (ServerData)lastServerData, (boolean)false));
    }
}

