/*
 * Decompiled with CFR 0.152.
 */
package me.ddkolbb.dreconnect.client;

import dev.architectury.event.events.client.ClientTickEvent;
import java.util.Objects;
import me.ddkolbb.dreconnect.config.DreconnectConfig;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_412;
import net.minecraft.class_419;
import net.minecraft.class_437;
import net.minecraft.class_639;
import net.minecraft.class_642;

public final class AutoReconnectClient {
    private static boolean enabled = false;
    private static int countdownSeconds = 0;
    private static class_642 lastServerData = null;
    private static int tickCounter = 0;
    private static int lastX;
    private static int lastY;
    private static int lastW;
    private static int lastH;

    public static void init() {
        DreconnectConfig.load();
        ClientTickEvent.CLIENT_POST.register(client -> {
            class_437 screen;
            if (client != null && client.method_1558() != null) {
                lastServerData = client.method_1558();
            }
            if ((screen = client.field_1755) instanceof class_419 && enabled) {
                if (countdownSeconds == 0 && lastServerData != null) {
                    countdownSeconds = DreconnectConfig.getCountdownSeconds();
                }
                if (countdownSeconds > 0 && ++tickCounter >= 20) {
                    tickCounter = 0;
                    if (--countdownSeconds <= 0) {
                        AutoReconnectClient.tryReconnect();
                    }
                }
            } else {
                tickCounter = 0;
            }
        });
    }

    public static void onScreenOpened(class_437 screen) {
        countdownSeconds = screen instanceof class_419 ? (enabled && lastServerData != null ? DreconnectConfig.getCountdownSeconds() : 0) : 0;
    }

    public static void onRender(class_437 screen, class_332 guiGraphics) {
        if (screen instanceof class_419) {
            AutoReconnectClient.renderToggle(guiGraphics, screen);
        }
    }

    public static boolean onMouseClicked(class_437 screen, double mouseX, double mouseY, int button) {
        if (!(screen instanceof class_419)) {
            return false;
        }
        return AutoReconnectClient.handleClick(screen, mouseX, mouseY, button);
    }

    public static boolean onKeyPressed(class_437 screen, int keyCode) {
        if (!(screen instanceof class_419)) {
            return false;
        }
        if (keyCode == 82) {
            AutoReconnectClient.toggleEnabled();
            return true;
        }
        return false;
    }

    private static void renderToggle(class_332 graphics, class_437 screen) {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        int width = screen.field_22789;
        int height = screen.field_22790;
        Object text = !enabled ? "AutoReconnect: OFF" : (countdownSeconds > 0 ? "Reconnect in " + countdownSeconds + "..." : "AutoReconnect: ON");
        int color = countdownSeconds > 0 ? 0xFFFFFF : (enabled ? 0xE0E0E0 : 0xB0B0B0);
        int margin = 6;
        int textWidth = mc.field_1772.method_1727((String)text);
        int x = Math.max(margin, width - textWidth - margin);
        Objects.requireNonNull(mc.field_1772);
        int y = Math.max(margin, height - 9 - margin);
        graphics.method_51433(mc.field_1772, (String)text, x, y, color, true);
        lastX = x;
        lastY = y;
        lastW = textWidth;
        Objects.requireNonNull(mc.field_1772);
        lastH = 9;
    }

    private static boolean handleClick(class_437 screen, double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        if (mouseX >= (double)(lastX - 3) && mouseX <= (double)(lastX + lastW + 3) && mouseY >= (double)(lastY - 2) && mouseY <= (double)(lastY + lastH + 2)) {
            AutoReconnectClient.toggleEnabled();
            return true;
        }
        return false;
    }

    private static void toggleEnabled() {
        boolean bl = enabled = !enabled;
        if (enabled) {
            class_310 mc = class_310.method_1551();
            if (mc != null && mc.field_1755 instanceof class_419 && lastServerData != null) {
                countdownSeconds = DreconnectConfig.getCountdownSeconds();
            }
        } else {
            countdownSeconds = 0;
        }
    }

    private static void tryReconnect() {
        class_310 mc = class_310.method_1551();
        if (mc == null || lastServerData == null) {
            return;
        }
        class_437 parent = mc.field_1755;
        countdownSeconds = 0;
        tickCounter = 0;
        class_639 address = class_639.method_2950((String)AutoReconnectClient.lastServerData.field_3761);
        mc.execute(() -> class_412.method_36877((class_437)parent, (class_310)mc, (class_639)address, (class_642)lastServerData, (boolean)false));
    }
}

