/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.showmethetime.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.theblackcat.showmethetime.ShowMeTheTimeClient;
import net.theblackcat.showmethetime.config.ClientConfig;

@Environment(value=EnvType.CLIENT)
public class ModCommands {
    public static final String ENABLE = "show-me-the-time.command.enabled.set.";
    public static final String SCALE = "show-me-the-time.command.scale.";
    public static final String CONVENTION = "show-me-the-time.command.time_convention.set";
    public static final String POSITION = "show-me-the-time.command.position.set";
    private static final String PADDING_X = "show-me-the-time.command.padding_x.";
    private static final String PADDING_Y = "show-me-the-time.command.padding_y.";

    public static void Register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 access) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"showmethetime").then(ClientCommandManager.literal((String)"enabled").then(ClientCommandManager.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(ModCommands::Enable)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"scale").then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"scale.set", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)5.0f)).executes(ModCommands::SetScale)))).then(ClientCommandManager.literal((String)"query").executes(ModCommands::GetScale))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"scale.add", (ArgumentType)FloatArgumentType.floatArg()).executes(ModCommands::AddScale))))).then(ClientCommandManager.literal((String)"timeConvention").then(ClientCommandManager.argument((String)"time_convention", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("12hr");
            builder.suggest("24hr");
            return builder.buildFuture();
        }).executes(ModCommands::SetConvention)))).then(ClientCommandManager.literal((String)"position").then(ClientCommandManager.argument((String)"position", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (ClientConfig.Positions position : ClientConfig.Positions.values()) {
                builder.suggest(ModCommands.ToCamel(position.name()));
            }
            return builder.buildFuture();
        }).executes(ModCommands::SetPosition)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"paddings").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"x").then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"padding_x.set", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(ModCommands::SetPaddingX)))).then(ClientCommandManager.literal((String)"query").executes(ModCommands::GetPaddingX))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"padding_x.add", (ArgumentType)IntegerArgumentType.integer()).executes(ModCommands::AddPaddingX))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"y").then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"padding_y.set", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(ModCommands::SetPaddingY)))).then(ClientCommandManager.literal((String)"query").executes(ModCommands::GetPaddingY))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"padding_y.add", (ArgumentType)IntegerArgumentType.integer()).executes(ModCommands::AddPaddingY))))));
    }

    private static void OnUpdate() {
        ShowMeTheTimeClient.CONFIG.Save();
    }

    private static int Enable(CommandContext<FabricClientCommandSource> context) {
        ShowMeTheTimeClient.CONFIG.turnOn = BoolArgumentType.getBool(context, (String)"enabled");
        ModCommands.Feedback(context, ENABLE + ShowMeTheTimeClient.CONFIG.turnOn, new Object[0]);
        ModCommands.OnUpdate();
        return 1;
    }

    private static int GetScale(CommandContext<FabricClientCommandSource> context) {
        ModCommands.Feedback(context, "show-me-the-time.command.scale.get", Float.valueOf(ShowMeTheTimeClient.CONFIG.scale));
        return 1;
    }

    private static int SetScale(CommandContext<FabricClientCommandSource> context) {
        ShowMeTheTimeClient.CONFIG.scale = FloatArgumentType.getFloat(context, (String)"scale.set");
        ModCommands.OnUpdate();
        return 1;
    }

    private static int AddScale(CommandContext<FabricClientCommandSource> context) {
        float current = ShowMeTheTimeClient.CONFIG.scale;
        float add = FloatArgumentType.getFloat(context, (String)"scale.add");
        if (add != 0.0f) {
            if (add > 0.0f) {
                add = Math.min(add, 5.0f - current);
                ModCommands.Feedback(context, "show-me-the-time.command.scale.add", Float.valueOf(add));
            } else {
                add = Math.max(add, -current);
                ModCommands.Feedback(context, "show-me-the-time.command.scale.subtract", Float.valueOf(Math.abs(add)));
            }
            ShowMeTheTimeClient.CONFIG.scale = Math.clamp(current + add, 0.0f, 5.0f);
            ModCommands.OnUpdate();
        }
        return 1;
    }

    private static int SetConvention(CommandContext<FabricClientCommandSource> context) {
        String name = StringArgumentType.getString(context, (String)"time_convention");
        ShowMeTheTimeClient.CONFIG.convention = name.equals("12hr") ? ClientConfig.TimeConvention.TWELVE : ClientConfig.TimeConvention.TWENTY_FOUR;
        ModCommands.Feedback(context, CONVENTION, ModCommands.GetConventionTranslation(ShowMeTheTimeClient.CONFIG.convention));
        ModCommands.OnUpdate();
        return 1;
    }

    private static class_2561 GetConventionTranslation(ClientConfig.TimeConvention convention) {
        return class_2561.method_43471((String)("show-me-the-time.time_convention." + convention.name()));
    }

    private static int SetPosition(CommandContext<FabricClientCommandSource> context) {
        String name = StringArgumentType.getString(context, (String)"position");
        name = ModCommands.ToUnderscoreUpper(name);
        ShowMeTheTimeClient.CONFIG.position = ClientConfig.Positions.valueOf(name);
        ModCommands.Feedback(context, POSITION, ModCommands.GetPositionTranslation(ShowMeTheTimeClient.CONFIG.position));
        ModCommands.OnUpdate();
        return 1;
    }

    private static class_2561 GetPositionTranslation(ClientConfig.Positions position) {
        return class_2561.method_43471((String)("show-me-the-time.position." + position.name()));
    }

    private static int SetPaddingX(CommandContext<FabricClientCommandSource> context) {
        int x = IntegerArgumentType.getInteger(context, (String)"padding_x.set");
        ShowMeTheTimeClient.CONFIG.paddingX = Math.clamp((long)x, 0, 100);
        ModCommands.Feedback(context, "show-me-the-time.command.padding_x.set", x);
        ModCommands.OnUpdate();
        return 1;
    }

    private static int SetPaddingY(CommandContext<FabricClientCommandSource> context) {
        int y = IntegerArgumentType.getInteger(context, (String)"padding_y.set");
        ShowMeTheTimeClient.CONFIG.paddingY = Math.clamp((long)y, 0, 100);
        ModCommands.Feedback(context, "show-me-the-time.command.padding_y.set", y);
        ModCommands.OnUpdate();
        return 1;
    }

    private static int AddPaddingX(CommandContext<FabricClientCommandSource> context) {
        int current = ShowMeTheTimeClient.CONFIG.paddingX;
        int add = IntegerArgumentType.getInteger(context, (String)"padding_x.add");
        if (add != 0) {
            if (add > 0) {
                add = Math.min(add, 100 - current);
                ModCommands.Feedback(context, "show-me-the-time.command.padding_x.add", add);
            } else {
                add = Math.max(add, -current);
                ModCommands.Feedback(context, "show-me-the-time.command.padding_x.subtract", Math.abs(add));
            }
            ShowMeTheTimeClient.CONFIG.paddingX = Math.clamp((long)(current + add), 0, 100);
            ModCommands.OnUpdate();
        }
        return 1;
    }

    private static int AddPaddingY(CommandContext<FabricClientCommandSource> context) {
        int current = ShowMeTheTimeClient.CONFIG.paddingY;
        int add = IntegerArgumentType.getInteger(context, (String)"padding_y.add");
        if (add != 0) {
            if (add > 0) {
                add = Math.min(add, 100 - current);
                ModCommands.Feedback(context, "show-me-the-time.command.padding_y.add", add);
            } else {
                add = Math.max(add, -current);
                ModCommands.Feedback(context, "show-me-the-time.command.padding_y.subtract", Math.abs(add));
            }
            ShowMeTheTimeClient.CONFIG.paddingY = Math.clamp((long)(current + add), 0, 100);
            ModCommands.OnUpdate();
        }
        return 1;
    }

    private static int GetPaddingX(CommandContext<FabricClientCommandSource> context) {
        int padding = ShowMeTheTimeClient.CONFIG.paddingX;
        ModCommands.Feedback(context, "show-me-the-time.command.padding_x.get", padding);
        return 1;
    }

    private static int GetPaddingY(CommandContext<FabricClientCommandSource> context) {
        int padding = ShowMeTheTimeClient.CONFIG.paddingY;
        ModCommands.Feedback(context, "show-me-the-time.command.padding_y.get", padding);
        return 1;
    }

    private static void Feedback(CommandContext<FabricClientCommandSource> context, String key, Object ... args) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)key, (Object[])args));
    }

    private static String ToUnderscoreUpper(String camel) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camel.length(); ++i) {
            char c = camel.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
            } else {
                c = Character.toUpperCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String ToCamel(String underscoreUpper) {
        StringBuilder sb = new StringBuilder();
        boolean upper = false;
        for (int i = 0; i < underscoreUpper.length(); ++i) {
            char c = underscoreUpper.charAt(i);
            if (c == '_') {
                upper = true;
                continue;
            }
            if (upper) {
                sb.append(Character.toUpperCase(c));
                upper = false;
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }
}

