/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.showmethetime.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.theblackcat.showmethetime.ShowMeTheTime;

@Environment(value=EnvType.CLIENT)
public class ClientConfig {
    public boolean turnOn;
    public float scale;
    public TimeConvention convention;
    public Positions position;
    public int paddingX;
    public int paddingY;
    private static ClientConfig instance;

    public ClientConfig() throws IOException {
        if (ClientConfig.GetFile().createNewFile()) {
            this.SetDefault();
        } else {
            this.Read();
        }
    }

    private static File GetFile() {
        return FabricLoader.getInstance().getConfigDir().resolve("show_me_the_time.txt").toFile();
    }

    private void SetDefault() {
        this.turnOn = true;
        this.scale = 1.0f;
        this.convention = TimeConvention.TWENTY_FOUR;
        this.position = Positions.TOP_CENTRE;
        this.paddingX = 6;
        this.paddingY = 6;
        this.Save();
    }

    public void Save() {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ClientConfig.GetFile()), StandardCharsets.UTF_8));){
            writer.write(String.valueOf(this.turnOn) + "\n");
            writer.write(String.valueOf(this.scale) + "\n");
            writer.write(this.convention.name() + "\n");
            writer.write(this.position.name() + "\n");
            writer.write(String.valueOf(this.paddingX) + "\n");
            writer.write(String.valueOf(this.paddingY));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void Read() {
        try (BufferedReader reader = new BufferedReader(new FileReader(ClientConfig.GetFile()));){
            List<String> data = reader.lines().toList();
            if (data.size() != 6) {
                this.SetDefault();
                ShowMeTheTime.LOGGER.warn("Config file error, fallback to default settings.");
                return;
            }
            try {
                this.turnOn = Boolean.parseBoolean(data.get(0));
                this.scale = Float.parseFloat(data.get(1));
                this.convention = TimeConvention.valueOf(data.get(2));
                this.position = Positions.valueOf(data.get(3));
                this.paddingX = Integer.parseInt(data.get(4));
                this.paddingY = Integer.parseInt(data.get(5));
            }
            catch (Exception ex) {
                this.SetDefault();
                ShowMeTheTime.LOGGER.warn("Config parse error, fallback to default settings.", (Throwable)ex);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum TimeConvention {
        TWELVE,
        TWENTY_FOUR;

    }

    @Environment(value=EnvType.CLIENT)
    public static enum Positions {
        TOP_LEFT(1),
        TOP_CENTRE(2),
        TOP_RIGHT(3),
        CENTRE_LEFT(4),
        CENTRE_RIGHT(6),
        BOTTOM_LEFT(7),
        BOTTOM_RIGHT(9);

        public final int index;

        private Positions(int index) {
            this.index = index;
        }
    }
}

