/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.bettergrass.util;

import dev.ultimatchamp.bettergrass.compat.WilderWildCompat;
import dev.ultimatchamp.bettergrass.config.BetterGrassifyConfig;
import dev.ultimatchamp.bettergrass.util.BetterGrassifyCacheUtils;
import dev.ultimatchamp.bettergrass.util.BetterSnowPredicateUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2488;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

public class BetterSnowUtils {
    public static class_2680 getLayerNeighbour(class_1920 world, class_2338 selfPos) {
        BetterGrassifyCacheUtils.initCaches();
        for (class_2248 layer : BetterGrassifyCacheUtils.BETTER_SNOW_CACHE) {
            boolean layerCheck;
            class_2338[] directions = new class_2338[]{selfPos.method_10095(), selfPos.method_10072(), selfPos.method_10078(), selfPos.method_10067()};
            boolean[] isLayer = new boolean[4];
            for (int i = 0; i < 4; ++i) {
                class_2680 state = world.method_8320(directions[i]);
                isLayer[i] = state.method_27852(layer) || layer.equals(class_2246.field_10477) && (state.method_27852(class_2246.field_10491) || state.method_27852(class_2246.field_27879));
            }
            switch (BetterGrassifyConfig.load().betterSnow.betterSnowMode) {
                case OPTIFINE: {
                    boolean bl;
                    if (isLayer[0] || isLayer[1] || isLayer[2] || isLayer[3]) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case LAMBDA: {
                    boolean bl;
                    if ((isLayer[0] || isLayer[1]) && (isLayer[2] || isLayer[3]) || isLayer[0] && isLayer[1] || isLayer[2] && isLayer[3]) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = layerCheck = false;
                }
            }
            if (!layerCheck) continue;
            for (class_2338 direction : directions) {
                class_2680 state = world.method_8320(direction);
                if (layer instanceof class_2488 && (state.method_27852(class_2246.field_10491) || state.method_27852(class_2246.field_27879))) {
                    return layer.method_9564();
                }
                if (!state.method_27852(layer)) continue;
                if (state.method_28500((class_2769)class_2741.field_42835).isPresent()) {
                    return (class_2680)state.method_11657((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(4));
                }
                return state;
            }
        }
        return null;
    }

    public static boolean isLayerNeighbourSnow(class_1920 world, class_2338 selfPos) {
        class_2680 layerNeighbour = BetterSnowUtils.getLayerNeighbour(world, selfPos);
        return layerNeighbour != null && (layerNeighbour.method_27852(class_2246.field_10477) || layerNeighbour.method_27852(class_2246.field_10491) || layerNeighbour.method_27852(class_2246.field_27879));
    }

    public static boolean canHaveGhostSnowLayer(class_1920 world, class_2338 selfPos) {
        return BetterSnowUtils.canHaveGhostLayer(world, selfPos) && BetterSnowUtils.isLayerNeighbourSnow(world, selfPos);
    }

    public static boolean canHaveGhostLayer(class_1920 world, class_2338 selfPos) {
        boolean isLayer;
        if (BetterGrassifyConfig.load().betterSnow.betterSnowMode == BetterGrassifyConfig.BetterSnowMode.OFF) {
            return false;
        }
        if (FabricLoader.getInstance().isModLoaded("wilderwild") && WilderWildCompat.isSnowloggingOn()) {
            return false;
        }
        class_2680 self = world.method_8320(selfPos);
        class_265 outlineShape = self.method_26218((class_1922)world, selfPos);
        class_265 bottomFace = outlineShape.method_20538(class_2350.field_11033);
        double height = outlineShape.method_1105(class_2350.class_2351.field_11052) - outlineShape.method_1091(class_2350.class_2351.field_11052);
        boolean isWhitelistedBlock = BetterSnowPredicateUtils.isBlockWhitelisted(self);
        if (!(isWhitelistedBlock || !self.method_26215() && !self.method_27852(class_2246.field_10382) && !self.method_31709() && bottomFace.method_1091(class_2350.class_2351.field_11048) > 0.0 && bottomFace.method_1105(class_2350.class_2351.field_11048) < 1.0 && bottomFace.method_1091(class_2350.class_2351.field_11051) > 0.0 && bottomFace.method_1105(class_2350.class_2351.field_11051) < 1.0 && !(height <= 0.125))) {
            return false;
        }
        boolean bl = isLayer = BetterSnowUtils.getLayerNeighbour(world, selfPos) != null;
        if (!isLayer || !world.method_8320(selfPos.method_10074()).method_26206((class_1922)world, selfPos.method_10074(), class_2350.field_11036)) {
            return false;
        }
        boolean isWhitelistedTag = BetterSnowPredicateUtils.isTagWhitelisted(self);
        if (BetterSnowPredicateUtils.isWhitelistOn()) {
            return isWhitelistedBlock || isWhitelistedTag;
        }
        boolean isExcludedBlock = BetterSnowPredicateUtils.isBlockExcluded(self);
        boolean isExcludedTag = BetterSnowPredicateUtils.isTagExcluded(self);
        return !isExcludedBlock && !isExcludedTag;
    }
}

