/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.bettergrass.model;

import dev.ultimatchamp.bettergrass.compat.WilderWildCompat;
import dev.ultimatchamp.bettergrass.config.BetterGrassifyConfig;
import dev.ultimatchamp.bettergrass.util.BetterSnowUtils;
import dev.ultimatchamp.bettergrass.util.SpriteCalculator;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_5819;

public class BetterGrassifyBlockStateModel
extends ForwardingBakedModel
implements class_1087 {
    private BetterGrassifyConfig config;

    public BetterGrassifyBlockStateModel(class_1087 wrapped) {
        this.wrapped = wrapped;
        this.config = BetterGrassifyConfig.load();
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext emitter) {
        if (this.config.general.betterGrassMode == BetterGrassifyConfig.BetterGrassMode.OFF) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, emitter);
            return;
        }
        emitter.pushTransform(quad -> {
            this.config = BetterGrassifyConfig.load();
            class_2350 face = quad.lightFace();
            if (face.method_10166().method_10178() || state.method_31709() || !this.isFullQuad(quad)) {
                return true;
            }
            if (state.method_27852(class_2246.field_10566)) {
                if (this.isBelowNonFullBlock(blockView, pos, face)) {
                    BetterGrassifyBlockStateModel.spriteBake(quad, blockView.method_8320(pos.method_10084()), randomSupplier);
                }
            } else {
                this.betterGrassify(quad, blockView, state, pos, face, randomSupplier);
            }
            return true;
        });
        super.emitBlockQuads(blockView, state, pos, randomSupplier, emitter);
        emitter.popTransform();
    }

    public void betterGrassify(MutableQuadView quad, class_1920 world, class_2680 state, class_2338 pos, class_2350 face, Supplier<class_5819> randomSupplier) {
        if (this.config.general.betterGrassMode.equals((Object)BetterGrassifyConfig.BetterGrassMode.FANCY)) {
            if (BetterGrassifyBlockStateModel.canFullyConnect(world, state, pos, face)) {
                BetterGrassifyBlockStateModel.spriteBake(quad, BetterGrassifyBlockStateModel.isSnowy(world, pos) ? world.method_8320(pos.method_10084()) : state, randomSupplier);
            } else {
                this.betterSnowyGrass(quad, world, pos, face, randomSupplier);
            }
        } else if (this.config.general.betterGrassMode.equals((Object)BetterGrassifyConfig.BetterGrassMode.FAST)) {
            if (BetterGrassifyBlockStateModel.isSnowy(world, pos)) {
                BetterGrassifyBlockStateModel.spriteBake(quad, world.method_8320(pos.method_10084()), randomSupplier);
            } else if (BetterSnowUtils.canHaveGhostSnowLayer(world, pos.method_10084()) && this.config.general.blocks.snowy) {
                BetterGrassifyBlockStateModel.spriteBake(quad, BetterSnowUtils.getLayerNeighbour(world, pos.method_10084()), randomSupplier);
            } else {
                BetterGrassifyBlockStateModel.spriteBake(quad, world.method_8320(pos), randomSupplier);
            }
        }
    }

    public void betterSnowyGrass(MutableQuadView quad, class_1920 world, class_2338 pos, class_2350 face, Supplier<class_5819> randomSupplier) {
        class_2338 adjacentPos = pos.method_10093(face);
        if (BetterGrassifyBlockStateModel.isSnowy(world, pos) && BetterSnowUtils.canHaveGhostSnowLayer(world, adjacentPos)) {
            BetterGrassifyBlockStateModel.spriteBake(quad, world.method_8320(pos.method_10084()), randomSupplier);
        } else if (BetterSnowUtils.canHaveGhostSnowLayer(world, pos.method_10084()) && BetterGrassifyBlockStateModel.isSnowy(world, adjacentPos.method_10074())) {
            BetterGrassifyBlockStateModel.spriteBake(quad, world.method_8320(adjacentPos), randomSupplier);
        } else if (BetterSnowUtils.canHaveGhostSnowLayer(world, pos.method_10084()) && BetterSnowUtils.canHaveGhostSnowLayer(world, adjacentPos)) {
            if (!this.config.general.blocks.snowy) {
                return;
            }
            BetterGrassifyBlockStateModel.spriteBake(quad, BetterSnowUtils.getLayerNeighbour(world, pos.method_10084()), randomSupplier);
        }
    }

    private boolean isFullQuad(MutableQuadView quad) {
        if (!this.config.general.resourcePackCompatibilityMode) {
            return true;
        }
        float tolerance = 0.0625f;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        for (int i = 0; i < 4; ++i) {
            float y = quad.y(i);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        return minY <= tolerance && maxY >= 1.0f - tolerance;
    }

    private static boolean canFullyConnect(class_1920 world, class_2680 self, class_2338 selfPos, class_2350 direction) {
        return BetterGrassifyBlockStateModel.canConnect(world, self, selfPos, selfPos.method_10093(direction).method_10074());
    }

    private static boolean canConnect(class_1920 world, class_2680 self, class_2338 selfPos, class_2338 adjacentPos) {
        class_2680 adjacent = world.method_8320(adjacentPos);
        class_2338 upPos = adjacentPos.method_10084();
        class_2680 up = world.method_8320(upPos);
        return BetterGrassifyBlockStateModel.canConnect(self, adjacent) && (up.method_26215() || BetterGrassifyBlockStateModel.isSnowy(world, selfPos) || !up.method_26206((class_1922)world, upPos, class_2350.field_11033));
    }

    private static boolean canConnect(class_2680 self, class_2680 adjacent) {
        return self == adjacent;
    }

    private boolean isBelowNonFullBlock(class_1920 world, class_2338 selfPos, class_2350 direction) {
        class_2338 upPos = selfPos.method_10084();
        class_2680 up = world.method_8320(upPos);
        if (!up.method_27852(class_2246.field_10194) && !up.method_27852(class_2246.field_10362)) {
            return false;
        }
        if (up.method_27852(class_2246.field_10194) && !this.config.general.blocks.dirtPaths) {
            return false;
        }
        if (up.method_27852(class_2246.field_10362) && !this.config.general.blocks.farmLands) {
            return false;
        }
        return BetterGrassifyBlockStateModel.canFullyConnect(world, up, upPos, direction);
    }

    private static boolean isSnowy(class_1920 world, class_2338 selfPos) {
        if (FabricLoader.getInstance().isModLoaded("wilderwild") && WilderWildCompat.isSnowloggingOn()) {
            return false;
        }
        class_2680 self = world.method_8320(selfPos);
        return self.method_28500((class_2769)class_2741.field_12512).orElse(false) != false && !world.method_8320(selfPos.method_10084()).method_26215();
    }

    private static void spriteBake(MutableQuadView quad, class_2680 state, Supplier<class_5819> randomSupplier) {
        class_1058 sprite = SpriteCalculator.calculateSprite(state, class_2350.field_11036, randomSupplier);
        if (sprite != null) {
            quad.spriteBake(sprite, 4);
        }
    }
}

