/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.common.level.blocks;

import com.github.hoshinofw.buildstonetoolkit.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IProxyBlock {
    public static final IntegerProperty POWER_LEVEL;

    default public boolean isPowered(@NotNull Level level, BlockPos pos) {
        return level.hasNeighborSignal(pos);
    }

    default public boolean isPowered(BlockState state) {
        return this.getPowerLevel(state) != 0;
    }

    default public boolean isStronglyPowered(@NotNull Level level, BlockPos pos) {
        return this.parseRedstoneToPowerLevel(level.getBestNeighborSignal(pos)) == 2;
    }

    default public boolean isStronglyPowered(BlockState state) {
        return this.getPowerLevel(state) == 2;
    }

    default public boolean isWeaklyPowered(@NotNull Level level, BlockPos pos) {
        return this.isPowered(level, pos) && !this.isStronglyPowered(level, pos);
    }

    default public boolean isWeaklyPowered(BlockState state) {
        return this.isPowered(state) && !this.isStronglyPowered(state);
    }

    default public int getPowerLevel(@NotNull Level level, BlockPos pos) {
        return this.getPowerLevel(level.getBlockState(pos));
    }

    default public int getPowerLevel(BlockState state) {
        if (!1.$assertionsDisabled && !(state.getBlock() instanceof IProxyBlock)) {
            throw new AssertionError();
        }
        return (Integer)state.getValue((Property)POWER_LEVEL);
    }

    default public void setPowerLevel(@NotNull Level level, BlockPos pos, int value) {
        BlockState state = level.getBlockState(pos);
        if (!1.$assertionsDisabled && !(state.getBlock() instanceof IProxyBlock)) {
            throw new AssertionError();
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)POWER_LEVEL, (Comparable)Integer.valueOf(value)), 3);
    }

    default public BlockState setPowerLevel(BlockState state, int value) {
        if (!1.$assertionsDisabled && !(state.getBlock() instanceof IProxyBlock)) {
            throw new AssertionError();
        }
        return (BlockState)state.setValue((Property)POWER_LEVEL, (Comparable)Integer.valueOf(value));
    }

    default public int parseRedstoneToPowerLevel(int inputSignal) {
        if (inputSignal == 0) {
            return 0;
        }
        if (inputSignal > 7) {
            return 2;
        }
        return 1;
    }

    default public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean bl) {
        this.setPowerLevel(level, pos, this.parseRedstoneToPowerLevel(level.getBestNeighborSignal(pos)));
    }

    default public void onPlace(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean bl) {
        this.neighborChanged(newState, level, pos, newState.getBlock(), pos, bl);
    }

    public boolean shouldPreserveTargetAbsPos(@NotNull Level var1, @NotNull PistonMovingBlockEntity var2, BlockPos var3, BlockPos var4, Direction var5);

    public boolean shouldTransferMovement(BlockPos var1, BlockState var2, Direction var3);

    @Nullable
    public BlockPos getLinkedBlockPos(@NotNull Level var1, BlockPos var2);

    default public BlockState getLinkedBlockState(@NotNull Level level, BlockPos pos) {
        return level.getBlockState(this.getLinkedBlockPos(level, pos));
    }

    public Util.FailableResult<BlockPos> parsePos(@NotNull Level var1, BlockPos var2, BlockPos var3);

    public boolean setLinkedRelPos(@NotNull Level var1, BlockPos var2, BlockPos var3);

    default public boolean setLinkedAbsPos(Level level, BlockPos pos, BlockPos newTargetBlockPos) {
        Util.FailableResult<BlockPos> parsedResult = this.parsePos(level, pos, newTargetBlockPos);
        BlockPos parsedPos = parsedResult.value();
        return this.setLinkedRelPos(level, pos, parsedPos) && parsedResult.succeeded();
    }

    public void offsetLinkedPos(Level var1, BlockPos var2, BlockState var3, Direction var4);

    public void offsetLinkedPos(Level var1, BlockPos var2, BlockState var3, Direction var4, int var5);

    public BlockState computeNewStateWithPreservedTargetAbsPos(Level var1, BlockPos var2, BlockState var3, Direction var4);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        POWER_LEVEL = IntegerProperty.create((String)"power_level", (int)0, (int)2);
    }
}

