/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.registries.events;

import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyBlock;
import com.github.hoshinofw.buildstonetoolkit.registries.BuildstoneItems;
import com.github.hoshinofw.buildstonetoolkit.util.EventUtil;
import com.github.hoshinofw.buildstonetoolkit.util.ParticleUtil;
import com.github.hoshinofw.buildstonetoolkit.util.Util;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.common.InteractionEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BuildstoneCommonEvents {
    public static void register() {
        InteractionEvent.RIGHT_CLICK_ITEM.register(BuildstoneCommonEvents::onRightClickItem);
    }

    private static CompoundEventResult<ItemStack> onRightClickItem(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is((Item)BuildstoneItems.MOD_WAND.get())) {
            HitResult hit = player.pick(32.0, 0.0f, false);
            Level level = player.level();
            if (hit instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hit;
                BlockPos hitPos = blockHitResult.getBlockPos();
                if (level.getBlockState(hitPos).getBlock() == Blocks.AIR) {
                    Util.setSelectedPos(player, null);
                } else {
                    Block block = level.getBlockState(hitPos).getBlock();
                    if (block instanceof IProxyBlock) {
                        IProxyBlock proxyBlock = (IProxyBlock)block;
                        if (!player.isShiftKeyDown()) {
                            EventUtil.rightClickWandOnProxy(player, proxyBlock, level, hitPos);
                        } else {
                            Util.setSelectedPos(player, hitPos);
                            ParticleUtil.spawnProxyTargetParticle(player, hitPos);
                            ParticleUtil.spawnProxyParticle(player, hitPos);
                        }
                    } else {
                        Util.setSelectedPos(player, hitPos);
                        if (level.isClientSide) {
                            ParticleUtil.spawnSelectionParticle(player, hitPos);
                        }
                    }
                }
            } else {
                Util.setSelectedPos(player, null);
            }
        }
        return CompoundEventResult.pass();
    }
}

