/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.util;

import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyBlock;
import com.github.hoshinofw.buildstonetoolkit.common.particles.TargetBlockParticle.BlockParticle;
import com.github.hoshinofw.buildstonetoolkit.registries.BuildstoneItems;
import com.github.hoshinofw.buildstonetoolkit.util.Util;
import com.github.hoshinofw.buildstonetoolkit.util.client.BlockParticleTexture;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ParticleUtil {
    public static BooleanSupplier targetParticleShouldPersist(@NotNull Player player, @NotNull BlockPos targetPos) {
        return () -> (player.getItemBySlot(EquipmentSlot.MAINHAND).is((Item)BuildstoneItems.MOD_WAND.get()) || player.getItemBySlot(EquipmentSlot.OFFHAND).is((Item)BuildstoneItems.MOD_WAND.get())) && Util.getSelectedPos(player) == targetPos;
    }

    public static void spawnSelectionParticle(@NotNull Player player, @NotNull BlockPos targetPos) {
        Level level = player.level();
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            BlockParticle particle = BlockParticle.create(clientLevel, targetPos).setRGBATint(1.0f, 1.0f, 1.0f, 0.85f).setSize(1.0f).setTextureIndex(BlockParticleTexture.SELECTION_BLOCK).setPersistSupplier(ParticleUtil.targetParticleShouldPersist(player, targetPos));
            Minecraft.getInstance().particleEngine.add((Particle)particle);
        }
    }

    public static void spawnProxyParticle(@NotNull Player player, @NotNull BlockPos proxyPos) {
        Block block = player.level().getBlockState(proxyPos).getBlock();
        if (block instanceof IProxyBlock) {
            IProxyBlock proxyBlock = (IProxyBlock)block;
            Level level = player.level();
            if (level instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)level;
                BlockPos targetPos = proxyBlock.getLinkedBlockPos(player.level(), proxyPos);
                if (targetPos == null) {
                    return;
                }
                BlockParticle particle = BlockParticle.create(clientLevel, proxyPos).setRGBATint(1.0f, 1.0f, 1.0f, 0.85f).setSize(1.0f).setTextureIndex(BlockParticleTexture.PROXY_BLOCK).setPersistSupplier(ParticleUtil.targetParticleShouldPersist(player, proxyPos));
                Minecraft.getInstance().particleEngine.add((Particle)particle);
            }
        }
    }

    public static void spawnProxyTargetParticle(@NotNull Player player, @NotNull BlockPos proxyPos) {
        Block block = player.level().getBlockState(proxyPos).getBlock();
        if (block instanceof IProxyBlock) {
            IProxyBlock proxyBlock = (IProxyBlock)block;
            BlockPos targetPos = proxyBlock.getLinkedBlockPos(player.level(), proxyPos);
            if (targetPos == null) {
                return;
            }
            Level level = player.level();
            if (level instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)level;
                BlockParticle particle = BlockParticle.create(clientLevel, targetPos).setRGBATint(1.0f, 1.0f, 1.0f, 0.85f).setSize(1.0f).setTextureIndex(BlockParticleTexture.PROXY_TARGET_BLOCK).setPersistSupplier(ParticleUtil.targetParticleShouldPersist(player, proxyPos));
                Minecraft.getInstance().particleEngine.add((Particle)particle);
            }
        }
    }
}

