/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.common.level.blocks;

import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyBlock;
import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyEntityBlock;
import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.entity.GuidedProxyBlockEntity;
import com.github.hoshinofw.buildstonetoolkit.util.Util;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2669;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuidedProxy
extends class_2248
implements IProxyBlock,
IProxyEntityBlock,
class_2343 {
    public static final class_2753 LINK_DIRECTION = class_2753.method_35305((String)"link_direction");

    public GuidedProxy(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)LINK_DIRECTION, (Comparable)class_2350.field_11036)).method_11657((class_2769)POWER_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public void method_9568(class_1799 itemStack, @Nullable class_1922 blockGetter, List<class_2561> list, class_1836 tooltipFlag) {
        if (class_437.method_25442()) {
            list.add((class_2561)class_2561.method_43471((String)"tooltip.buildstonetoolkit.guided_proxy.details"));
        } else {
            list.add((class_2561)class_2561.method_43471((String)"tooltip.buildstonetoolkit.hold_shift"));
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LINK_DIRECTION}).method_11667(new class_2769[]{POWER_LEVEL});
    }

    public class_2680 method_9605(class_1750 blockPlaceContext) {
        return (class_2680)this.method_9564().method_11657((class_2769)LINK_DIRECTION, (Comparable)blockPlaceContext.method_7715().method_10153());
    }

    public static class_2350 getDirection(@NotNull class_1937 level, class_2338 proxyPos) {
        return (class_2350)level.method_8320(proxyPos).method_11654((class_2769)LINK_DIRECTION);
    }

    public static void setDirection(@NotNull class_1937 level, class_2338 proxyPos, class_2350 direction) {
        level.method_8652(proxyPos, (class_2680)level.method_8320(proxyPos).method_11657((class_2769)LINK_DIRECTION, (Comparable)direction), 3);
    }

    public static int getDistance(@NotNull class_1937 level, class_2338 proxyPos) {
        return ((GuidedProxyBlockEntity)Objects.requireNonNull(level.method_8321(proxyPos))).getDistance();
    }

    public static void setDistance(@NotNull class_1937 level, class_2338 proxyPos, int newDistance) {
        if (newDistance == 0) {
            ((GuidedProxyBlockEntity)Objects.requireNonNull(level.method_8321(proxyPos))).setDistance(newDistance);
            return;
        }
        if (newDistance > 0) {
            ((GuidedProxyBlockEntity)Objects.requireNonNull(level.method_8321(proxyPos))).setDistance(newDistance);
            GuidedProxy.setDirection(level, proxyPos, Util.getPositiveDirection(((class_2350)level.method_8320(proxyPos).method_11654((class_2769)LINK_DIRECTION)).method_10166()));
            return;
        }
        ((GuidedProxyBlockEntity)Objects.requireNonNull(level.method_8321(proxyPos))).setDistance(-1 * newDistance);
        GuidedProxy.setDirection(level, proxyPos, Util.getPositiveDirection(((class_2350)level.method_8320(proxyPos).method_11654((class_2769)LINK_DIRECTION)).method_10166()).method_10153());
    }

    @Override
    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 pos2, boolean bl) {
        IProxyBlock.super.method_9612(state, level, pos, block, pos2, bl);
    }

    @Override
    public void method_9615(class_2680 oldState, class_1937 level, class_2338 pos, class_2680 newState, boolean bl) {
        IProxyBlock.super.method_9615(oldState, level, pos, newState, bl);
    }

    @Override
    public boolean shouldPreserveTargetAbsPos(@NotNull class_1937 level, @NotNull class_2669 mbe, class_2338 originalPos, class_2338 finalPos, class_2350 moveDirection) {
        if (this.isStronglyPowered(mbe.method_11495())) {
            return true;
        }
        return this.isWeaklyPowered(level, finalPos);
    }

    @Override
    public boolean shouldTransferMovement(class_2338 pos, class_2680 state, class_2350 blockLineRecursionDirection) {
        return this.getPowerLevel(state) == 0;
    }

    @Override
    public class_2338 getLinkedBlockPos(@NotNull class_1937 level, class_2338 blockPos) {
        return blockPos.method_10079((class_2350)level.method_8320(blockPos).method_11654((class_2769)LINK_DIRECTION), ((GuidedProxyBlockEntity)Objects.requireNonNull(level.method_8321(blockPos))).getDistance());
    }

    @Override
    public Util.FailableResult<class_2338> parsePos(@NotNull class_1937 level, class_2338 proxyPos, class_2338 inputPos) {
        class_2350.class_2351 proxyAxis;
        class_2338 processedPos;
        class_2338 rawPos = inputPos.method_10059((class_2382)proxyPos);
        if (Util.deepEquals(rawPos, processedPos = Util.projectOntoAxis(rawPos, proxyAxis = GuidedProxy.getDirection(level, proxyPos).method_10166()))) {
            return new Util.FailableResult<class_2338>(processedPos, true);
        }
        return new Util.FailableResult<class_2338>(processedPos, false);
    }

    @Override
    public boolean setLinkedRelPos(@NotNull class_1937 level, class_2338 proxyPos, class_2338 newRelativeTargetPos) {
        class_2350.class_2351 proxyAxis = GuidedProxy.getDirection(level, proxyPos).method_10166();
        int posValueInAxis = newRelativeTargetPos.method_30558(proxyAxis);
        GuidedProxy.setDistance(level, proxyPos, posValueInAxis);
        return Util.isNonZeroOnlyOn(newRelativeTargetPos, proxyAxis);
    }

    @Override
    public class_2680 computeNewStateWithPreservedTargetAbsPos(class_1937 level, class_2338 pos, class_2680 state, class_2350 moveDirection) {
        return null;
    }

    @Override
    public class_2680 computeNewStateWithPreservedTargetAbsPos(class_1937 level, class_2338 pos, class_2487 nbt, class_2680 state, class_2350 moveDirection) {
        int newDistance = GuidedProxy.computeOffset(state, nbt, moveDirection, 1);
        class_2680 newState = this.method_9564();
        newState = newDistance >= 0 ? (class_2680)newState.method_11657((class_2769)LINK_DIRECTION, (Comparable)((class_2350)state.method_11654((class_2769)LINK_DIRECTION))) : (class_2680)newState.method_11657((class_2769)LINK_DIRECTION, (Comparable)moveDirection.method_10153());
        return newState;
    }

    @Override
    public class_2487 computeNewNBTWithPreservedTargetAbsPos(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2487 nbt, class_2350 moveDirection) {
        assert (nbt != null);
        class_2487 nbtOutput = nbt.method_10553();
        int newDistance = GuidedProxy.computeOffset(state, nbt, moveDirection, 1);
        nbtOutput.method_10569("link_distance", newDistance);
        return nbtOutput;
    }

    @Override
    public void offsetLinkedPos(class_1937 level, class_2338 pos, class_2680 state, class_2350 direction) {
        GuidedProxyBlockEntity blockEntity = (GuidedProxyBlockEntity)level.method_8321(pos);
        if (blockEntity == null) {
            return;
        }
        class_2680 newState = state;
        int newDistance = GuidedProxy.computeOffset(state, blockEntity, direction, 1);
        if (newDistance >= 0) {
            blockEntity.setDistance(newDistance);
        } else {
            blockEntity.setDistance(1);
            newState = (class_2680)state.method_11657((class_2769)LINK_DIRECTION, (Comparable)direction.method_10153());
        }
        level.method_8652(pos, newState, 3);
        level.method_8438((class_2586)blockEntity);
    }

    @Override
    public void offsetLinkedPos(class_1937 level, class_2338 pos, class_2680 state, class_2350 direction, int i) {
        GuidedProxyBlockEntity blockEntity = (GuidedProxyBlockEntity)level.method_8321(pos);
        if (blockEntity == null) {
            return;
        }
        class_2680 newState = state;
        int newDistance = GuidedProxy.computeOffset(state, blockEntity, direction, i);
        if (newDistance >= 0) {
            blockEntity.setDistance(newDistance);
        } else {
            blockEntity.setDistance(1);
            newState = (class_2680)state.method_11657((class_2769)LINK_DIRECTION, (Comparable)direction.method_10153());
        }
        level.method_8652(pos, newState, 3);
        level.method_8438((class_2586)blockEntity);
    }

    public static int computeOffset(class_2680 state, GuidedProxyBlockEntity ppbe, class_2350 offsetDirection, int i) {
        return i * (ppbe.getDistance() + GuidedProxy.compareDirections(offsetDirection, (class_2350)state.method_11654((class_2769)LINK_DIRECTION)));
    }

    public static int computeOffset(class_2680 state, class_2487 ppbeTag, class_2350 offsetDirection, int i) {
        return i * (ppbeTag.method_10550("link_distance") + GuidedProxy.compareDirections(offsetDirection, (class_2350)state.method_11654((class_2769)LINK_DIRECTION)));
    }

    public static int compareDirections(class_2350 a, class_2350 b) {
        if (a == b.method_10153()) {
            return 1;
        }
        if (a == b) {
            return -1;
        }
        return 0;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new GuidedProxyBlockEntity(blockPos, blockState);
    }
}

