/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.common.particles.TargetBlockParticle;

import com.github.hoshinofw.buildstonetoolkit.client.Sprites;
import com.github.hoshinofw.buildstonetoolkit.common.level.items.ModWand;
import com.github.hoshinofw.buildstonetoolkit.common.particles.TargetBlockParticle.BlockParticleOptions;
import com.github.hoshinofw.buildstonetoolkit.util.client.BlockParticleTexture;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.platform.Platform;
import java.util.function.BooleanSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockParticle
extends class_4003 {
    private class_4002 sprites;
    private static final BlockParticleRenderProvider renderer = Platform.isFabric() ? new FabricRenderer() : new NFRenderer();
    float minU;
    float maxU;
    float minV;
    float maxV;
    private float r;
    private float g;
    private float b;
    private float a = 1.0f;
    private float alpha;
    private float size = 1.0f;
    private BooleanSupplier shouldPersist = () -> false;
    private boolean fading = false;
    private int fadeTicks = 0;
    private static final int fadeDuration = 5;
    public static final class_243[] CUBE = new class_243[]{new class_243(1.0, 1.0, -1.0), new class_243(1.0, 1.0, 1.0), new class_243(-1.0, 1.0, 1.0), new class_243(-1.0, 1.0, -1.0), new class_243(-1.0, -1.0, -1.0), new class_243(-1.0, -1.0, 1.0), new class_243(1.0, -1.0, 1.0), new class_243(1.0, -1.0, -1.0), new class_243(-1.0, -1.0, 1.0), new class_243(-1.0, 1.0, 1.0), new class_243(1.0, 1.0, 1.0), new class_243(1.0, -1.0, 1.0), new class_243(1.0, -1.0, -1.0), new class_243(1.0, 1.0, -1.0), new class_243(-1.0, 1.0, -1.0), new class_243(-1.0, -1.0, -1.0), new class_243(-1.0, -1.0, -1.0), new class_243(-1.0, 1.0, -1.0), new class_243(-1.0, 1.0, 1.0), new class_243(-1.0, -1.0, 1.0), new class_243(1.0, -1.0, 1.0), new class_243(1.0, 1.0, 1.0), new class_243(1.0, 1.0, -1.0), new class_243(1.0, -1.0, -1.0)};
    public static final class_3999 NO_DEPTH = new class_3999(){

        public void method_18130(class_287 bufferBuilder, class_1060 textureManager) {
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_17898);
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(class_757::method_34546);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1584);
        }

        public void method_18131(class_289 tesselator) {
            tesselator.method_1350();
        }

        public String toString() {
            return "buildstonetoolkit:no_depth_particle";
        }
    };
    public static final class_3999 RENDER_TYPE = Platform.isFabric() ? class_3999.field_17829 : NO_DEPTH;

    protected BlockParticle(class_638 clientLevel, class_2338 pos, class_4002 spriteSet) {
        super(clientLevel, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        this.sprites = spriteSet;
        this.setTextureSprite(spriteSet);
        this.updateUVValues();
    }

    public static BlockParticle create(class_638 clientLevel, class_2338 pos, class_4002 spriteSet) {
        ModWand.setClientMode(ModWand.Mode.ON);
        return new BlockParticle(clientLevel, pos, spriteSet);
    }

    public static BlockParticle create(class_638 clientLevel, class_2338 pos) {
        ModWand.setClientMode(ModWand.Mode.ON);
        return new BlockParticle(clientLevel, pos, Sprites.BLOCK_PARTICLE_SPRITES);
    }

    public BlockParticle setRGBATint(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.alpha = a;
        return this;
    }

    public BlockParticle setSize(float size) {
        this.size = size;
        return this;
    }

    public BlockParticle setPersistSupplier(BooleanSupplier supplier) {
        this.shouldPersist = supplier;
        return this;
    }

    public BlockParticle setTextureSprite(class_4002 spriteSet) {
        this.sprites = spriteSet;
        this.method_18140(spriteSet);
        this.updateUVValues();
        return this;
    }

    public BlockParticle setTextureIndex(BlockParticleTexture texture) {
        this.method_18141(this.sprites.method_18138(texture.index(), 2));
        this.updateUVValues();
        return this;
    }

    private void updateUVValues() {
        this.minU = this.field_17886.method_4594();
        this.maxU = this.field_17886.method_4577();
        this.minV = this.field_17886.method_4593();
        this.maxV = this.field_17886.method_4575();
    }

    @Environment(value=EnvType.CLIENT)
    public void method_3074(class_4588 consumer, @NotNull class_4184 camera, float partialTicks) {
        renderer.render(consumer, camera, partialTicks, this);
    }

    public void method_3070() {
        if (!this.fading) {
            ModWand.setClientMode(ModWand.Mode.ON);
            if (!this.shouldPersist.getAsBoolean()) {
                this.fading = true;
                this.fadeTicks = 0;
            }
        } else {
            ++this.fadeTicks;
            float fadeProgress = (float)this.fadeTicks / 5.0f;
            this.alpha = class_3532.method_15363((float)(1.0f - fadeProgress), (float)0.0f, (float)1.0f) * this.a;
            if (this.fadeTicks >= 5) {
                this.method_3085();
                ModWand.setClientMode(ModWand.Mode.OFF);
            }
        }
    }

    @NotNull
    public class_3999 method_18122() {
        return RENDER_TYPE;
    }

    @Environment(value=EnvType.CLIENT)
    public static interface BlockParticleRenderProvider {
        default public void render(class_4588 consumer, @NotNull class_4184 camera, float partialTicks, BlockParticle particle) {
            class_243 projectedView = camera.method_19326();
            float x = (float)(particle.field_3874 - projectedView.method_10216());
            float y = (float)(particle.field_3854 - projectedView.method_10214());
            float z = (float)(particle.field_3871 - projectedView.method_10215());
            int light = 0xF000F0;
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 4; ++j) {
                    float u;
                    class_243 vec = CUBE[i * 4 + j].method_1021(-1.0).method_1021((double)(particle.size / 2.0f + 0.001f)).method_1031((double)x, (double)y, (double)z);
                    consumer.method_22912((double)((float)vec.field_1352), (double)((float)vec.field_1351), (double)((float)vec.field_1350)).method_22913(u, switch (j) {
                        case 0 -> {
                            u = particle.maxU;
                            yield particle.maxV;
                        }
                        case 1 -> {
                            u = particle.maxU;
                            yield particle.minV;
                        }
                        case 2 -> {
                            u = particle.minU;
                            yield particle.minV;
                        }
                        default -> {
                            u = particle.minU;
                            yield particle.maxV;
                        }
                    }).method_22915(particle.r, particle.g, particle.b, particle.alpha).method_22916(light).method_1344();
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FabricRenderer
    implements BlockParticleRenderProvider {
        @Override
        public void render(class_4588 consumer, @NotNull class_4184 camera, float partialTicks, BlockParticle particle) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            BlockParticleRenderProvider.super.render(consumer, camera, partialTicks, particle);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class NFRenderer
    implements BlockParticleRenderProvider {
        @Override
        public void render(class_4588 consumer, @NotNull class_4184 camera, float partialTicks, BlockParticle particle) {
            BlockParticleRenderProvider.super.render(consumer, camera, partialTicks, particle);
        }
    }

    public static class Provider
    implements class_707<BlockParticleOptions> {
        private final class_4002 sprite;

        public Provider(class_4002 spriteSet) {
            this.sprite = spriteSet;
        }

        @Nullable
        public class_703 createParticle(BlockParticleOptions particleOptions, class_638 clientLevel, double x, double y, double z, double dx, double dy, double dz) {
            return BlockParticle.create(clientLevel, new class_2338((int)x, (int)y, (int)z), this.sprite).setRGBATint(1.0f, 1.0f, 1.0f, 0.8f).setSize(1.0f).setTextureSprite(this.sprite).setTextureIndex(BlockParticleTexture.SELECTION_BLOCK);
        }
    }
}

