/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.mixin;

import com.github.hoshinofw.buildstonetoolkit.common.level.items.ModWand;
import com.github.hoshinofw.buildstonetoolkit.util.ParticleUtil;
import com.github.hoshinofw.buildstonetoolkit.util.SoundUtil;
import com.github.hoshinofw.buildstonetoolkit.util.Util;
import com.github.hoshinofw.buildstonetoolkit.util.mixin.AllayMixinInterface;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Allay.class})
public class AllayMixin
extends PathfinderMob
implements AllayMixinInterface {
    @Unique
    private static List<Double> buildstonetoolkit$allowedDistances = List.of(Double.valueOf(0.0), Double.valueOf(0.5), Double.valueOf(1.0), Double.valueOf(2.0), Double.valueOf(3.0), Double.valueOf(5.0), Double.valueOf(7.0), Double.valueOf(9.0));
    @Unique
    private Util.ValueCycler<Double> buildstonetoolkit$distanceCycler = new Util.ValueCycler<Double>(buildstonetoolkit$allowedDistances, this::buildstonetoolkit$getMaxDistanceToOrigin, this::buildstonetoolkit$setMaxDistanceToOrigin);
    @Unique
    private Vec3 buildstonetoolkit$searchOrigin = null;
    @Unique
    private double buildstonetoolkit$maxDistanceToOrigin = 3.0;

    protected AllayMixin(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Unique
    @Nullable
    public Vec3 buildstonetoolkit$getSearchOrigin() {
        return this.buildstonetoolkit$searchOrigin;
    }

    @Unique
    @Nullable
    public BlockPos buildstonetoolkit$getSearchOriginAsPos() {
        if (this.buildstonetoolkit$searchOrigin == null) {
            return null;
        }
        return BlockPos.containing((Position)this.buildstonetoolkit$searchOrigin);
    }

    @Override
    @Unique
    public void buildstonetoolkit$setSearchOrigin(Vec3 value) {
        this.buildstonetoolkit$searchOrigin = value;
    }

    @Override
    @Unique
    public double buildstonetoolkit$getMaxDistanceToOrigin() {
        return this.buildstonetoolkit$maxDistanceToOrigin;
    }

    @Override
    @Unique
    public void buildstonetoolkit$setMaxDistanceToOrigin(double value) {
        this.buildstonetoolkit$maxDistanceToOrigin = value;
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    protected void mobInteract(Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack playerIS = player.getItemInHand(interactionHand);
        if (playerIS.getItem() instanceof ModWand) {
            BlockPos selectedPos = Util.getSelectedPos(player);
            BlockPos storedAllaySearchPos = this.buildstonetoolkit$getSearchOriginAsPos();
            if (!player.isShiftKeyDown()) {
                this.buildstonetoolkit$setAllaySearchOrigin(player, selectedPos);
            } else if (Util.deepEquals(selectedPos, storedAllaySearchPos)) {
                if (!player.level().isClientSide()) {
                    this.buildstonetoolkit$distanceCycler.next();
                    player.displayClientMessage((Component)Component.translatable((String)"message.buildstonetoolkit.allay_distance_set", (Object[])new Object[]{Util.yellowComponent(Double.toString(this.buildstonetoolkit$getMaxDistanceToOrigin()))}), true);
                } else {
                    SoundUtil.playAllayConfirmationSound(player);
                }
            } else {
                Util.setSelectedPos(player, storedAllaySearchPos);
                if (!player.level().isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.buildstonetoolkit.allay_tracking"), true);
                } else {
                    if (storedAllaySearchPos != null) {
                        ParticleUtil.spawnSelectionParticle(player, storedAllaySearchPos);
                    }
                    SoundUtil.playAllayConfirmationSound(player);
                }
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            cir.cancel();
        }
    }

    @Unique
    private void buildstonetoolkit$setAllaySearchOrigin(Player player, BlockPos selectedPos) {
        if (selectedPos != null) {
            this.buildstonetoolkit$setSearchOrigin(selectedPos.getCenter());
            if (!player.level().isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.buildstonetoolkit.allay_link_success", (Object[])new Object[]{Util.blueComponent(Arrays.toString(Util.blockPosToArray(selectedPos)))}), true);
            } else {
                SoundUtil.playAllayConfirmationSound(player);
            }
        } else {
            this.buildstonetoolkit$setSearchOrigin(null);
            if (!player.level().isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.buildstonetoolkit.allay_link_remove", (Object[])new Object[]{Util.blueComponent(Component.translatable((String)"message.buildstonetoolkit.allay_link_remove_2").getString())}), true);
            } else {
                SoundUtil.playAllayConfirmationSound(player);
            }
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        Vec3 origin = this.buildstonetoolkit$getSearchOrigin();
        if (origin != null) {
            compoundTag.putIntArray("searchOrigin", Util.blockPosToArray(BlockPos.containing((Position)origin)));
        }
        compoundTag.putFloat("maxSearchDistance", (float)this.buildstonetoolkit$getMaxDistanceToOrigin());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        this.buildstonetoolkit$setSearchOrigin(Util.getSearchOriginFromNBT(compoundTag));
        this.buildstonetoolkit$setMaxDistanceToOrigin(compoundTag.getFloat("maxSearchDistance"));
    }
}

