/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.buildstonetoolkit.mixin;

import com.github.hoshinofw.buildstonetoolkit.util.mixin.AllayMixinInterface;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.GoAndGiveItemsToTarget;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.allay.AllayAi;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GoAndGiveItemsToTarget.class})
public class GoAndGiveItemsToTargetMixin {
    @Unique
    private static final Item buildstonetoolkit$globalPlayerTrackItem = Items.DIAMOND;
    @Shadow
    @Final
    private Function<LivingEntity, Optional<PositionTracker>> targetPositionGetter;

    @Shadow
    public static void throwItem(LivingEntity arg, ItemStack arg2, Vec3 arg3) {
    }

    @Shadow
    private static Vec3 getThrowPosition(PositionTracker arg) {
        return null;
    }

    @Shadow
    private void triggerDropItemOnBlock(PositionTracker arg, ItemStack arg2, ServerPlayer arg3) {
    }

    @Inject(method={"tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;J)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void tick(ServerLevel serverLevel, LivingEntity entity, long l, CallbackInfo ci) {
        Optional<PositionTracker> optional = this.targetPositionGetter.apply(entity);
        if (optional.isPresent() && entity instanceof Allay) {
            Allay allayEntity = (Allay)entity;
            PositionTracker positionTracker = optional.get();
            Vec3 allaySearchOrigin = ((AllayMixinInterface)allayEntity).buildstonetoolkit$getSearchOrigin();
            if (allaySearchOrigin == null) {
                allaySearchOrigin = allayEntity.getEyePosition();
            }
            if (allayEntity.getMainHandItem().is(buildstonetoolkit$globalPlayerTrackItem)) {
                ItemStack itemStack;
                ServerPlayer nearestPlayer = (ServerPlayer)Objects.requireNonNull(serverLevel.getNearestPlayer(allaySearchOrigin.x, allaySearchOrigin.y, allaySearchOrigin.z, 20.0, true));
                Vec3 nearestPlayerPos = nearestPlayer.getEyePosition();
                double d = nearestPlayerPos.distanceTo(allaySearchOrigin);
                if (d < ((AllayMixinInterface)allayEntity).buildstonetoolkit$getMaxDistanceToOrigin() && !(itemStack = allayEntity.getInventory().removeItem(0, 1)).isEmpty()) {
                    GoAndGiveItemsToTargetMixin.throwItem((LivingEntity)allayEntity, itemStack, GoAndGiveItemsToTargetMixin.getThrowPosition(positionTracker));
                    this.triggerDropItemOnBlock(positionTracker, itemStack, nearestPlayer);
                    allayEntity.getBrain().setMemory(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, (Object)60);
                }
            } else {
                ItemStack itemStack;
                double d = positionTracker.currentPosition().distanceTo(allaySearchOrigin);
                if (d < ((AllayMixinInterface)allayEntity).buildstonetoolkit$getMaxDistanceToOrigin() && !(itemStack = allayEntity.getInventory().removeItem(0, 1)).isEmpty()) {
                    GoAndGiveItemsToTargetMixin.throwItem((LivingEntity)allayEntity, itemStack, GoAndGiveItemsToTargetMixin.getThrowPosition(positionTracker));
                    AllayAi.getLikedPlayer((LivingEntity)allayEntity).ifPresent(arg3 -> this.triggerDropItemOnBlock(positionTracker, itemStack, (ServerPlayer)arg3));
                    allayEntity.getBrain().setMemory(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, (Object)60);
                }
            }
            ci.cancel();
        }
    }
}

